/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinIntentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBuiltinIntentResponse.Builder, GetBuiltinIntentResponse> {
    private final String signature;

    private final List<String> supportedLocales;

    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    /**
     * <p>
     * The unique identifier for a built-in intent.
     * </p>
     * 
     * @return The unique identifier for a built-in intent.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of locales that the intent supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of locales that the intent supports.
     * @see Locale
     */
    public List<String> supportedLocales() {
        return supportedLocales;
    }

    /**
     * <p>
     * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
     */
    public List<BuiltinIntentSlot> slots() {
        return slots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((signature() == null) ? 0 : signature().hashCode());
        hashCode = 31 * hashCode + ((supportedLocales() == null) ? 0 : supportedLocales().hashCode());
        hashCode = 31 * hashCode + ((slots() == null) ? 0 : slots().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse) obj;
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.supportedLocales() == null ^ this.supportedLocales() == null) {
            return false;
        }
        if (other.supportedLocales() != null && !other.supportedLocales().equals(this.supportedLocales())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (signature() != null) {
            sb.append("Signature: ").append(signature()).append(",");
        }
        if (supportedLocales() != null) {
            sb.append("SupportedLocales: ").append(supportedLocales()).append(",");
        }
        if (slots() != null) {
            sb.append("Slots: ").append(slots()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        /**
         * <p>
         * The unique identifier for a built-in intent.
         * </p>
         * 
         * @param signature
         *        The unique identifier for a built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(String... supportedLocales);

        /**
         * <p>
         * A list of locales that the intent supports.
         * </p>
         * 
         * @param supportedLocales
         *        A list of locales that the intent supports.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(Locale... supportedLocales);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<BuiltinIntentSlot> slots);

        /**
         * <p>
         * An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * </p>
         * 
         * @param slots
         *        An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(BuiltinIntentSlot... slots);
    }

    private static final class BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales;

        private List<BuiltinIntentSlot> slots;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            setSignature(model.signature);
            setSupportedLocales(model.supportedLocales);
            setSlots(model.slots);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale... supportedLocales) {
            supportedLocales(Arrays.asList(supportedLocales).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public final Collection<BuiltinIntentSlot> getSlots() {
            return slots;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
        }

        @Override
        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }
    }
}
