/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.IntentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the specific version of an intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Intent implements StructuredPojo, ToCopyableBuilder<Intent.Builder, Intent> {
    private final String intentName;

    private final String intentVersion;

    private Intent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentVersion = builder.intentVersion;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The version of the intent.
     * </p>
     * 
     * @return The version of the intent.
     */
    public String intentVersion() {
        return intentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((intentName() == null) ? 0 : intentName().hashCode());
        hashCode = 31 * hashCode + ((intentVersion() == null) ? 0 : intentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent) obj;
        if (other.intentName() == null ^ this.intentName() == null) {
            return false;
        }
        if (other.intentName() != null && !other.intentName().equals(this.intentName())) {
            return false;
        }
        if (other.intentVersion() == null ^ this.intentVersion() == null) {
            return false;
        }
        if (other.intentVersion() != null && !other.intentVersion().equals(this.intentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (intentName() != null) {
            sb.append("IntentName: ").append(intentName()).append(",");
        }
        if (intentVersion() != null) {
            sb.append("IntentVersion: ").append(intentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Intent> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param intentName
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The version of the intent.
         * </p>
         * 
         * @param intentVersion
         *        The version of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentVersion(String intentVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String intentName;

        private String intentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            setIntentName(model.intentName);
            setIntentVersion(model.intentVersion);
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getIntentVersion() {
            return intentVersion;
        }

        @Override
        public final Builder intentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        public final void setIntentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
        }

        @Override
        public Intent build() {
            return new Intent(this);
        }
    }
}
