/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutIntentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutIntentRequest.Builder, PutIntentRequest> {
    private final String name;

    private final String description;

    private final List<Slot> slots;

    private final List<String> sampleUtterances;

    private final Prompt confirmationPrompt;

    private final Statement rejectionStatement;

    private final FollowUpPrompt followUpPrompt;

    private final Statement conclusionStatement;

    private final CodeHook dialogCodeHook;

    private final FulfillmentActivity fulfillmentActivity;

    private final String parentIntentSignature;

    private final String checksum;

    private PutIntentRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the intent. The name is <i>not</i> case sensitive.
     * </p>
     * <p>
     * The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example,
     * because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent called
     * <code>HelpIntent</code>.
     * </p>
     * <p>
     * For a list of built-in intents, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The name of the intent. The name is <i>not</i> case sensitive. </p>
     *         <p>
     *         The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For
     *         example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a
     *         custom intent called <code>HelpIntent</code>.
     *         </p>
     *         <p>
     *         For a list of built-in intents, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the intent.
     * </p>
     * 
     * @return A description of the intent.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined
     * in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
     *         defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
     */
    public List<Slot> slots() {
        return slots;
    }

    /**
     * <p>
     * An array of utterances (strings) that a user might say to signal the intent. For example,
     * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * </p>
     * <p>
     * In each utterance, a slot name is enclosed in curly braces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of utterances (strings) that a user might say to signal the intent. For example,
     *         "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
     *         <p>
     *         In each utterance, a slot name is enclosed in curly braces.
     */
    public List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     * </p>
     * <p>
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For
     * example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before
     * placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask
     * the user for confirmation before providing the information.
     * </p>
     * <note>
     * <p>
     * You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     * neither.
     * </p>
     * </note>
     * 
     * @return Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
     *         <p>
     *         Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
     *         fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
     *         order is correct before placing it. For other intents, such as intents that simply respond to user
     *         questions, you might not need to ask the user for confirmation before providing the information.
     *         </p>
     *         <note>
     *         <p>
     *         You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     *         neither.
     *         </p>
     */
    public Prompt confirmationPrompt() {
        return confirmationPrompt;
    }

    /**
     * <p>
     * When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with
     * this statement to acknowledge that the intent was canceled.
     * </p>
     * <note>
     * <p>
     * You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.
     * </p>
     * </note>
     * 
     * @return When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
     *         responds with this statement to acknowledge that the intent was canceled. </p> <note>
     *         <p>
     *         You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
     *         neither.
     *         </p>
     */
    public Statement rejectionStatement() {
        return rejectionStatement;
    }

    /**
     * <p>
     * A user prompt for additional activity after an intent is fulfilled. For example, after the
     * <code>OrderPizza</code> intent is fulfilled (your Lambda function placed an order with a pizzeria), you might
     * prompt the user to find if they want to order a drink (assuming that you have defined an <code>OrderDrink</code>
     * intent in your bot).
     * </p>
     * <note>
     * <p>
     * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only
     * one. For example, your bot may not solicit both the following:
     * </p>
     * <p>
     * Follow up prompt - "<code>$session.FirstName</code>, your pizza order has been placed. Would you like to order a
     * drink or a dessert?"
     * </p>
     * <p>
     * Conclusion statement - "<code>$session.FirstName</code>, your pizza order has been placed."
     * </p>
     * </note>
     * 
     * @return A user prompt for additional activity after an intent is fulfilled. For example, after the
     *         <code>OrderPizza</code> intent is fulfilled (your Lambda function placed an order with a pizzeria), you
     *         might prompt the user to find if they want to order a drink (assuming that you have defined an
     *         <code>OrderDrink</code> intent in your bot).</p> <note>
     *         <p>
     *         The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
     *         specify only one. For example, your bot may not solicit both the following:
     *         </p>
     *         <p>
     *         Follow up prompt - "<code>$session.FirstName</code>, your pizza order has been placed. Would you like to
     *         order a drink or a dessert?"
     *         </p>
     *         <p>
     *         Conclusion statement - "<code>$session.FirstName</code>, your pizza order has been placed."
     *         </p>
     */
    public FollowUpPrompt followUpPrompt() {
        return followUpPrompt;
    }

    /**
     * <p>
     * The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the
     * Lambda function.
     * </p>
     * <p>
     * This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you
     * return the intent to the client application, you can't specify this element.
     * </p>
     * <note>
     * <p>
     * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only
     * one.
     * </p>
     * </note>
     * 
     * @return The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled
     *         by the Lambda function. </p>
     *         <p>
     *         This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>.
     *         If you return the intent to the client application, you can't specify this element.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
     *         specify only one.
     *         </p>
     */
    public Statement conclusionStatement() {
        return conclusionStatement;
    }

    /**
     * <p>
     * Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize
     * user interaction.
     * </p>
     * <p>
     * For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's
     * information from a backend database and prepopulate some of the values. For example, if you find that John is
     * gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might
     * find John's phone number and set the corresponding session attribute.
     * </p>
     * 
     * @return Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to
     *         personalize user interaction. </p>
     *         <p>
     *         For example, suppose your bot determines that the user is John. Your Lambda function might retrieve
     *         John's information from a backend database and prepopulate some of the values. For example, if you find
     *         that John is gluten intolerant, you might set the corresponding intent slot,
     *         <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding
     *         session attribute.
     */
    public CodeHook dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza
     * order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store.
     * </p>
     * <p>
     * You might configure Amazon Lex to return all of the intent information to the client application, or direct it to
     * invoke a Lambda function that can process the intent (for example, place an order with a pizzeria).
     * </p>
     * 
     * @return Describes how the intent is fulfilled. For example, after a user provides all of the information for a
     *         pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza
     *         store. </p>
     *         <p>
     *         You might configure Amazon Lex to return all of the intent information to the client application, or
     *         direct it to invoke a Lambda function that can process the intent (for example, place an order with a
     *         pizzeria).
     */
    public FulfillmentActivity fulfillmentActivity() {
        return fulfillmentActivity;
    }

    /**
     * <p>
     * A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a
     * href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return A unique identifier for the built-in intent to base this intent on. To find the signature for an intent,
     *         see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
     *         >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
     */
    public String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision
     * of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum
     * does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you
     *         get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent
     *         revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or
     *         if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((slots() == null) ? 0 : slots().hashCode());
        hashCode = 31 * hashCode + ((sampleUtterances() == null) ? 0 : sampleUtterances().hashCode());
        hashCode = 31 * hashCode + ((confirmationPrompt() == null) ? 0 : confirmationPrompt().hashCode());
        hashCode = 31 * hashCode + ((rejectionStatement() == null) ? 0 : rejectionStatement().hashCode());
        hashCode = 31 * hashCode + ((followUpPrompt() == null) ? 0 : followUpPrompt().hashCode());
        hashCode = 31 * hashCode + ((conclusionStatement() == null) ? 0 : conclusionStatement().hashCode());
        hashCode = 31 * hashCode + ((dialogCodeHook() == null) ? 0 : dialogCodeHook().hashCode());
        hashCode = 31 * hashCode + ((fulfillmentActivity() == null) ? 0 : fulfillmentActivity().hashCode());
        hashCode = 31 * hashCode + ((parentIntentSignature() == null) ? 0 : parentIntentSignature().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentRequest)) {
            return false;
        }
        PutIntentRequest other = (PutIntentRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        if (other.sampleUtterances() == null ^ this.sampleUtterances() == null) {
            return false;
        }
        if (other.sampleUtterances() != null && !other.sampleUtterances().equals(this.sampleUtterances())) {
            return false;
        }
        if (other.confirmationPrompt() == null ^ this.confirmationPrompt() == null) {
            return false;
        }
        if (other.confirmationPrompt() != null && !other.confirmationPrompt().equals(this.confirmationPrompt())) {
            return false;
        }
        if (other.rejectionStatement() == null ^ this.rejectionStatement() == null) {
            return false;
        }
        if (other.rejectionStatement() != null && !other.rejectionStatement().equals(this.rejectionStatement())) {
            return false;
        }
        if (other.followUpPrompt() == null ^ this.followUpPrompt() == null) {
            return false;
        }
        if (other.followUpPrompt() != null && !other.followUpPrompt().equals(this.followUpPrompt())) {
            return false;
        }
        if (other.conclusionStatement() == null ^ this.conclusionStatement() == null) {
            return false;
        }
        if (other.conclusionStatement() != null && !other.conclusionStatement().equals(this.conclusionStatement())) {
            return false;
        }
        if (other.dialogCodeHook() == null ^ this.dialogCodeHook() == null) {
            return false;
        }
        if (other.dialogCodeHook() != null && !other.dialogCodeHook().equals(this.dialogCodeHook())) {
            return false;
        }
        if (other.fulfillmentActivity() == null ^ this.fulfillmentActivity() == null) {
            return false;
        }
        if (other.fulfillmentActivity() != null && !other.fulfillmentActivity().equals(this.fulfillmentActivity())) {
            return false;
        }
        if (other.parentIntentSignature() == null ^ this.parentIntentSignature() == null) {
            return false;
        }
        if (other.parentIntentSignature() != null && !other.parentIntentSignature().equals(this.parentIntentSignature())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (slots() != null) {
            sb.append("Slots: ").append(slots()).append(",");
        }
        if (sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(sampleUtterances()).append(",");
        }
        if (confirmationPrompt() != null) {
            sb.append("ConfirmationPrompt: ").append(confirmationPrompt()).append(",");
        }
        if (rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(rejectionStatement()).append(",");
        }
        if (followUpPrompt() != null) {
            sb.append("FollowUpPrompt: ").append(followUpPrompt()).append(",");
        }
        if (conclusionStatement() != null) {
            sb.append("ConclusionStatement: ").append(conclusionStatement()).append(",");
        }
        if (dialogCodeHook() != null) {
            sb.append("DialogCodeHook: ").append(dialogCodeHook()).append(",");
        }
        if (fulfillmentActivity() != null) {
            sb.append("FulfillmentActivity: ").append(fulfillmentActivity()).append(",");
        }
        if (parentIntentSignature() != null) {
            sb.append("ParentIntentSignature: ").append(parentIntentSignature()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutIntentRequest> {
        /**
         * <p>
         * The name of the intent. The name is <i>not</i> case sensitive.
         * </p>
         * <p>
         * The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example,
         * because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent
         * called <code>HelpIntent</code>.
         * </p>
         * <p>
         * For a list of built-in intents, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param name
         *        The name of the intent. The name is <i>not</i> case sensitive. </p>
         *        <p>
         *        The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For
         *        example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a
         *        custom intent called <code>HelpIntent</code>.
         *        </p>
         *        <p>
         *        For a list of built-in intents, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the intent.
         * </p>
         * 
         * @param description
         *        A description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
         * defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
         * </p>
         * 
         * @param slots
         *        An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using
         *        prompts defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts
         * defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
         * </p>
         * 
         * @param slots
         *        An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using
         *        prompts defined in the slots. For more information, see &lt;xref linkend="how-it-works"/&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * An array of utterances (strings) that a user might say to signal the intent. For example,
         * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
         * </p>
         * <p>
         * In each utterance, a slot name is enclosed in curly braces.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of utterances (strings) that a user might say to signal the intent. For example,
         *        "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
         *        <p>
         *        In each utterance, a slot name is enclosed in curly braces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * An array of utterances (strings) that a user might say to signal the intent. For example,
         * "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
         * </p>
         * <p>
         * In each utterance, a slot name is enclosed in curly braces.
         * </p>
         * 
         * @param sampleUtterances
         *        An array of utterances (strings) that a user might say to signal the intent. For example,
         *        "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
         *        <p>
         *        In each utterance, a slot name is enclosed in curly braces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * <note>
         * <p>
         * You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note>
         * 
         * @param confirmationPrompt
         *        Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
         *        <p>
         *        Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
         *        fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
         *        order is correct before placing it. For other intents, such as intents that simply respond to user
         *        questions, you might not need to ask the user for confirmation before providing the information.
         *        </p>
         *        <note>
         *        <p>
         *        You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>,
         *        or neither.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationPrompt(Prompt confirmationPrompt);

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds
         * with this statement to acknowledge that the intent was canceled.
         * </p>
         * <note>
         * <p>
         * You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         * neither.
         * </p>
         * </note>
         * 
         * @param rejectionStatement
         *        When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex
         *        responds with this statement to acknowledge that the intent was canceled. </p> <note>
         *        <p>
         *        You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or
         *        neither.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * A user prompt for additional activity after an intent is fulfilled. For example, after the
         * <code>OrderPizza</code> intent is fulfilled (your Lambda function placed an order with a pizzeria), you might
         * prompt the user to find if they want to order a drink (assuming that you have defined an
         * <code>OrderDrink</code> intent in your bot).
         * </p>
         * <note>
         * <p>
         * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify
         * only one. For example, your bot may not solicit both the following:
         * </p>
         * <p>
         * Follow up prompt - "<code>$session.FirstName</code>, your pizza order has been placed. Would you like to
         * order a drink or a dessert?"
         * </p>
         * <p>
         * Conclusion statement - "<code>$session.FirstName</code>, your pizza order has been placed."
         * </p>
         * </note>
         * 
         * @param followUpPrompt
         *        A user prompt for additional activity after an intent is fulfilled. For example, after the
         *        <code>OrderPizza</code> intent is fulfilled (your Lambda function placed an order with a pizzeria),
         *        you might prompt the user to find if they want to order a drink (assuming that you have defined an
         *        <code>OrderDrink</code> intent in your bot).</p> <note>
         *        <p>
         *        The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
         *        specify only one. For example, your bot may not solicit both the following:
         *        </p>
         *        <p>
         *        Follow up prompt - "<code>$session.FirstName</code>, your pizza order has been placed. Would you like
         *        to order a drink or a dessert?"
         *        </p>
         *        <p>
         *        Conclusion statement - "<code>$session.FirstName</code>, your pizza order has been placed."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followUpPrompt(FollowUpPrompt followUpPrompt);

        /**
         * <p>
         * The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by
         * the Lambda function.
         * </p>
         * <p>
         * This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If
         * you return the intent to the client application, you can't specify this element.
         * </p>
         * <note>
         * <p>
         * The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify
         * only one.
         * </p>
         * </note>
         * 
         * @param conclusionStatement
         *        The statement that you want Amazon Lex to convey to the user after the intent is successfully
         *        fulfilled by the Lambda function. </p>
         *        <p>
         *        This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>
         *        . If you return the intent to the client application, you can't specify this element.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can
         *        specify only one.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conclusionStatement(Statement conclusionStatement);

        /**
         * <p>
         * Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize
         * user interaction.
         * </p>
         * <p>
         * For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's
         * information from a backend database and prepopulate some of the values. For example, if you find that John is
         * gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You
         * might find John's phone number and set the corresponding session attribute.
         * </p>
         * 
         * @param dialogCodeHook
         *        Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to
         *        personalize user interaction. </p>
         *        <p>
         *        For example, suppose your bot determines that the user is John. Your Lambda function might retrieve
         *        John's information from a backend database and prepopulate some of the values. For example, if you
         *        find that John is gluten intolerant, you might set the corresponding intent slot,
         *        <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding
         *        session attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(CodeHook dialogCodeHook);

        /**
         * <p>
         * Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza
         * order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store.
         * </p>
         * <p>
         * You might configure Amazon Lex to return all of the intent information to the client application, or direct
         * it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria).
         * </p>
         * 
         * @param fulfillmentActivity
         *        Describes how the intent is fulfilled. For example, after a user provides all of the information for a
         *        pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza
         *        store. </p>
         *        <p>
         *        You might configure Amazon Lex to return all of the intent information to the client application, or
         *        direct it to invoke a Lambda function that can process the intent (for example, place an order with a
         *        pizzeria).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity);

        /**
         * <p>
         * A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see
         * <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         * >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for the built-in intent to base this intent on. To find the signature for an
         *        intent, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents"
         *        >Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get
         * a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum
         *        you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a intent, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Slot> slots;

        private List<String> sampleUtterances;

        private Prompt confirmationPrompt;

        private Statement rejectionStatement;

        private FollowUpPrompt followUpPrompt;

        private Statement conclusionStatement;

        private CodeHook dialogCodeHook;

        private FulfillmentActivity fulfillmentActivity;

        private String parentIntentSignature;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntentRequest model) {
            setName(model.name);
            setDescription(model.description);
            setSlots(model.slots);
            setSampleUtterances(model.sampleUtterances);
            setConfirmationPrompt(model.confirmationPrompt);
            setRejectionStatement(model.rejectionStatement);
            setFollowUpPrompt(model.followUpPrompt);
            setConclusionStatement(model.conclusionStatement);
            setDialogCodeHook(model.dialogCodeHook);
            setFulfillmentActivity(model.fulfillmentActivity);
            setParentIntentSignature(model.parentIntentSignature);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot> getSlots() {
            return slots;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
        }

        public final Collection<String> getSampleUtterances() {
            return sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt getConfirmationPrompt() {
            return confirmationPrompt;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
        }

        public final Statement getRejectionStatement() {
            return rejectionStatement;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
        }

        public final FollowUpPrompt getFollowUpPrompt() {
            return followUpPrompt;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
        }

        public final Statement getConclusionStatement() {
            return conclusionStatement;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
        }

        public final CodeHook getDialogCodeHook() {
            return dialogCodeHook;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
        }

        public final FulfillmentActivity getFulfillmentActivity() {
            return fulfillmentActivity;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public PutIntentRequest build() {
            return new PutIntentRequest(this);
        }
    }
}
