/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.SlotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the version of a specific slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Slot implements StructuredPojo, ToCopyableBuilder<Slot.Builder, Slot> {
    private final String name;

    private final String description;

    private final String slotConstraint;

    private final String slotType;

    private final String slotTypeVersion;

    private final Prompt valueElicitationPrompt;

    private final Integer priority;

    private final List<String> sampleUtterances;

    private final String responseCard;

    private Slot(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotType = builder.slotType;
        this.slotTypeVersion = builder.slotTypeVersion;
        this.valueElicitationPrompt = builder.valueElicitationPrompt;
        this.priority = builder.priority;
        this.sampleUtterances = builder.sampleUtterances;
        this.responseCard = builder.responseCard;
    }

    /**
     * <p>
     * The name of the slot.
     * </p>
     * 
     * @return The name of the slot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot.
     * </p>
     * 
     * @return A description of the slot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the slot is required or optional.
     * </p>
     * 
     * @return Specifies whether the slot is required or optional.
     * @see SlotConstraint
     */
    public String slotConstraint() {
        return slotConstraint;
    }

    /**
     * <p>
     * The type of the slot, either a custom slot type that you defined or one of the built-in slot types.
     * </p>
     * 
     * @return The type of the slot, either a custom slot type that you defined or one of the built-in slot types.
     */
    public String slotType() {
        return slotType;
    }

    /**
     * <p>
     * The version of the slot type.
     * </p>
     * 
     * @return The version of the slot type.
     */
    public String slotTypeVersion() {
        return slotTypeVersion;
    }

    /**
     * <p>
     * The prompt that Amazon Lex uses to elicit the slot value from the user.
     * </p>
     * 
     * @return The prompt that Amazon Lex uses to elicit the slot value from the user.
     */
    public Prompt valueElicitationPrompt() {
        return valueElicitationPrompt;
    }

    /**
     * <p>
     * Directs Lex the order in which to elicit this slot value from the user. For example, if the intent has two slots
     * with priorities 1 and 2, AWS Lex first elicits a value for the slot with priority 1.
     * </p>
     * <p>
     * If multiple slots share the same priority, the order in which Lex elicits values is arbitrary.
     * </p>
     * 
     * @return Directs Lex the order in which to elicit this slot value from the user. For example, if the intent has
     *         two slots with priorities 1 and 2, AWS Lex first elicits a value for the slot with priority 1.</p>
     *         <p>
     *         If multiple slots share the same priority, the order in which Lex elicits values is arbitrary.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value, you can
     * provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
     * understanding user utterances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value,
     *         you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is
     *         capable of understanding user utterances.
     */
    public List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * A set of possible responses for the slot type used by text-based clients. A user chooses an option from the
     * response card, instead of using text to reply.
     * </p>
     * 
     * @return A set of possible responses for the slot type used by text-based clients. A user chooses an option from
     *         the response card, instead of using text to reply.
     */
    public String responseCard() {
        return responseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((slotConstraint() == null) ? 0 : slotConstraint().hashCode());
        hashCode = 31 * hashCode + ((slotType() == null) ? 0 : slotType().hashCode());
        hashCode = 31 * hashCode + ((slotTypeVersion() == null) ? 0 : slotTypeVersion().hashCode());
        hashCode = 31 * hashCode + ((valueElicitationPrompt() == null) ? 0 : valueElicitationPrompt().hashCode());
        hashCode = 31 * hashCode + ((priority() == null) ? 0 : priority().hashCode());
        hashCode = 31 * hashCode + ((sampleUtterances() == null) ? 0 : sampleUtterances().hashCode());
        hashCode = 31 * hashCode + ((responseCard() == null) ? 0 : responseCard().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.slotConstraint() == null ^ this.slotConstraint() == null) {
            return false;
        }
        if (other.slotConstraint() != null && !other.slotConstraint().equals(this.slotConstraint())) {
            return false;
        }
        if (other.slotType() == null ^ this.slotType() == null) {
            return false;
        }
        if (other.slotType() != null && !other.slotType().equals(this.slotType())) {
            return false;
        }
        if (other.slotTypeVersion() == null ^ this.slotTypeVersion() == null) {
            return false;
        }
        if (other.slotTypeVersion() != null && !other.slotTypeVersion().equals(this.slotTypeVersion())) {
            return false;
        }
        if (other.valueElicitationPrompt() == null ^ this.valueElicitationPrompt() == null) {
            return false;
        }
        if (other.valueElicitationPrompt() != null && !other.valueElicitationPrompt().equals(this.valueElicitationPrompt())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.sampleUtterances() == null ^ this.sampleUtterances() == null) {
            return false;
        }
        if (other.sampleUtterances() != null && !other.sampleUtterances().equals(this.sampleUtterances())) {
            return false;
        }
        if (other.responseCard() == null ^ this.responseCard() == null) {
            return false;
        }
        if (other.responseCard() != null && !other.responseCard().equals(this.responseCard())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (slotConstraint() != null) {
            sb.append("SlotConstraint: ").append(slotConstraint()).append(",");
        }
        if (slotType() != null) {
            sb.append("SlotType: ").append(slotType()).append(",");
        }
        if (slotTypeVersion() != null) {
            sb.append("SlotTypeVersion: ").append(slotTypeVersion()).append(",");
        }
        if (valueElicitationPrompt() != null) {
            sb.append("ValueElicitationPrompt: ").append(valueElicitationPrompt()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(sampleUtterances()).append(",");
        }
        if (responseCard() != null) {
            sb.append("ResponseCard: ").append(responseCard()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Slot> {
        /**
         * <p>
         * The name of the slot.
         * </p>
         * 
         * @param name
         *        The name of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot.
         * </p>
         * 
         * @param description
         *        A description of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the slot is required or optional.
         * </p>
         * 
         * @param slotConstraint
         *        Specifies whether the slot is required or optional.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(String slotConstraint);

        /**
         * <p>
         * Specifies whether the slot is required or optional.
         * </p>
         * 
         * @param slotConstraint
         *        Specifies whether the slot is required or optional.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(SlotConstraint slotConstraint);

        /**
         * <p>
         * The type of the slot, either a custom slot type that you defined or one of the built-in slot types.
         * </p>
         * 
         * @param slotType
         *        The type of the slot, either a custom slot type that you defined or one of the built-in slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotType(String slotType);

        /**
         * <p>
         * The version of the slot type.
         * </p>
         * 
         * @param slotTypeVersion
         *        The version of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeVersion(String slotTypeVersion);

        /**
         * <p>
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         * </p>
         * 
         * @param valueElicitationPrompt
         *        The prompt that Amazon Lex uses to elicit the slot value from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueElicitationPrompt(Prompt valueElicitationPrompt);

        /**
         * <p>
         * Directs Lex the order in which to elicit this slot value from the user. For example, if the intent has two
         * slots with priorities 1 and 2, AWS Lex first elicits a value for the slot with priority 1.
         * </p>
         * <p>
         * If multiple slots share the same priority, the order in which Lex elicits values is arbitrary.
         * </p>
         * 
         * @param priority
         *        Directs Lex the order in which to elicit this slot value from the user. For example, if the intent has
         *        two slots with priorities 1 and 2, AWS Lex first elicits a value for the slot with priority 1.</p>
         *        <p>
         *        If multiple slots share the same priority, the order in which Lex elicits values is arbitrary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value, you
         * can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
         * understanding user utterances.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern with which users might respond to an Amazon Lex request for a slot
         *        value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon
         *        Lex is capable of understanding user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value, you
         * can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
         * understanding user utterances.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern with which users might respond to an Amazon Lex request for a slot
         *        value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon
         *        Lex is capable of understanding user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * A set of possible responses for the slot type used by text-based clients. A user chooses an option from the
         * response card, instead of using text to reply.
         * </p>
         * 
         * @param responseCard
         *        A set of possible responses for the slot type used by text-based clients. A user chooses an option
         *        from the response card, instead of using text to reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCard(String responseCard);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String slotConstraint;

        private String slotType;

        private String slotTypeVersion;

        private Prompt valueElicitationPrompt;

        private Integer priority;

        private List<String> sampleUtterances;

        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            setName(model.name);
            setDescription(model.description);
            setSlotConstraint(model.slotConstraint);
            setSlotType(model.slotType);
            setSlotTypeVersion(model.slotTypeVersion);
            setValueElicitationPrompt(model.valueElicitationPrompt);
            setPriority(model.priority);
            setSampleUtterances(model.sampleUtterances);
            setResponseCard(model.responseCard);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSlotConstraint() {
            return slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint.toString());
            return this;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        public final String getSlotType() {
            return slotType;
        }

        @Override
        public final Builder slotType(String slotType) {
            this.slotType = slotType;
            return this;
        }

        public final void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        public final String getSlotTypeVersion() {
            return slotTypeVersion;
        }

        @Override
        public final Builder slotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
            return this;
        }

        public final void setSlotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
        }

        public final Prompt getValueElicitationPrompt() {
            return valueElicitationPrompt;
        }

        @Override
        public final Builder valueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
            return this;
        }

        public final void setValueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<String> getSampleUtterances() {
            return sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
        }

        public final String getResponseCard() {
            return responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        @Override
        public Slot build() {
            return new Slot(this);
        }
    }
}
