/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BotAliasMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a bot alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BotAliasMetadata implements StructuredPojo, ToCopyableBuilder<BotAliasMetadata.Builder, BotAliasMetadata> {
    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String checksum;

    private BotAliasMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot alias.
     * </p>
     * 
     * @return A description of the bot alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the Amazon Lex bot to which the alias points.
     * </p>
     * 
     * @return The version of the Amazon Lex bot to which the alias points.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot to which the alias points.
     * </p>
     * 
     * @return The name of the bot to which the alias points.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the bot alias was updated. When you create a resource, the creation date and last updated date are
     * the same.
     * </p>
     * 
     * @return The date that the bot alias was updated. When you create a resource, the creation date and last updated
     *         date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot alias was created.
     * </p>
     * 
     * @return The date that the bot alias was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Checksum of the bot alias.
     * </p>
     * 
     * @return Checksum of the bot alias.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((botVersion() == null) ? 0 : botVersion().hashCode());
        hashCode = 31 * hashCode + ((botName() == null) ? 0 : botName().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedDate() == null) ? 0 : lastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasMetadata)) {
            return false;
        }
        BotAliasMetadata other = (BotAliasMetadata) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.botVersion() == null ^ this.botVersion() == null) {
            return false;
        }
        if (other.botVersion() != null && !other.botVersion().equals(this.botVersion())) {
            return false;
        }
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.lastUpdatedDate() == null ^ this.lastUpdatedDate() == null) {
            return false;
        }
        if (other.lastUpdatedDate() != null && !other.lastUpdatedDate().equals(this.lastUpdatedDate())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (botVersion() != null) {
            sb.append("BotVersion: ").append(botVersion()).append(",");
        }
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(lastUpdatedDate()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BotAliasMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BotAliasMetadata> {
        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param name
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot alias.
         * </p>
         * 
         * @param description
         *        A description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the Amazon Lex bot to which the alias points.
         * </p>
         * 
         * @param botVersion
         *        The version of the Amazon Lex bot to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot to which the alias points.
         * </p>
         * 
         * @param botName
         *        The name of the bot to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the bot alias was updated. When you create a resource, the creation date and last updated date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot alias was updated. When you create a resource, the creation date and last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot alias was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Checksum of the bot alias.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasMetadata model) {
            setName(model.name);
            setDescription(model.description);
            setBotVersion(model.botVersion);
            setBotName(model.botName);
            setLastUpdatedDate(model.lastUpdatedDate);
            setCreatedDate(model.createdDate);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public BotAliasMetadata build() {
            return new BotAliasMetadata(this);
        }
    }
}
