/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSlotTypeVersionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateSlotTypeVersionRequest.Builder, CreateSlotTypeVersionRequest> {
    private final String name;

    private final String checksum;

    private CreateSlotTypeVersionRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the slot type that you want to create a new version for. The name is case sensitive.
     * </p>
     * 
     * @return The name of the slot type that you want to create a new version for. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a
     * checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a
     * <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you don't specify a
     * checksum, Amazon Lex publishes the <code>$LATEST</code> version.
     * </p>
     * 
     * @return Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a
     *         checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex
     *         returns a <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you
     *         don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSlotTypeVersionRequest)) {
            return false;
        }
        CreateSlotTypeVersionRequest other = (CreateSlotTypeVersionRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSlotTypeVersionRequest> {
        /**
         * <p>
         * The name of the slot type that you want to create a new version for. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the slot type that you want to create a new version for. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a
         * checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a
         * <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you don't specify
         * a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
         * </p>
         * 
         * @param checksum
         *        Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you
         *        specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum,
         *        Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish the new
         *        version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSlotTypeVersionRequest model) {
            setName(model.name);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public CreateSlotTypeVersionRequest build() {
            return new CreateSlotTypeVersionRequest(this);
        }
    }
}
