/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotRequest extends AmazonWebServiceRequest implements ToCopyableBuilder<GetBotRequest.Builder, GetBotRequest> {
    private final String name;

    private final String versionOrAlias;

    private GetBotRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.versionOrAlias = builder.versionOrAlias;
    }

    /**
     * <p>
     * The name of the bot. The name is case sensitive.
     * </p>
     * 
     * @return The name of the bot. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version or alias of the bot.
     * </p>
     * 
     * @return The version or alias of the bot.
     */
    public String versionOrAlias() {
        return versionOrAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((versionOrAlias() == null) ? 0 : versionOrAlias().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotRequest)) {
            return false;
        }
        GetBotRequest other = (GetBotRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.versionOrAlias() == null ^ this.versionOrAlias() == null) {
            return false;
        }
        if (other.versionOrAlias() != null && !other.versionOrAlias().equals(this.versionOrAlias())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (versionOrAlias() != null) {
            sb.append("VersionOrAlias: ").append(versionOrAlias()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBotRequest> {
        /**
         * <p>
         * The name of the bot. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the bot. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version or alias of the bot.
         * </p>
         * 
         * @param versionOrAlias
         *        The version or alias of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionOrAlias(String versionOrAlias);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String versionOrAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotRequest model) {
            setName(model.name);
            setVersionOrAlias(model.versionOrAlias);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionOrAlias() {
            return versionOrAlias;
        }

        @Override
        public final Builder versionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
            return this;
        }

        public final void setVersionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
        }

        @Override
        public GetBotRequest build() {
            return new GetBotRequest(this);
        }
    }
}
