/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetUtterancesViewRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetUtterancesViewRequest.Builder, GetUtterancesViewRequest> {
    private final String botName;

    private final List<String> botVersions;

    private final String statusType;

    private GetUtterancesViewRequest(BuilderImpl builder) {
        this.botName = builder.botName;
        this.botVersions = builder.botVersions;
        this.statusType = builder.statusType;
    }

    /**
     * <p>
     * The name of the bot for which utterance information should be returned.
     * </p>
     * 
     * @return The name of the bot for which utterance information should be returned.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of bot versions for which utterance information should be returned. The limit is 5 versions per
     *         request.
     */
    public List<String> botVersions() {
        return botVersions;
    }

    /**
     * <p>
     * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that were
     * not recognized, use <code>Missed</code>.
     * </p>
     * 
     * @return To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
     *         that were not recognized, use <code>Missed</code>.
     * @see StatusType
     */
    public String statusType() {
        return statusType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((botName() == null) ? 0 : botName().hashCode());
        hashCode = 31 * hashCode + ((botVersions() == null) ? 0 : botVersions().hashCode());
        hashCode = 31 * hashCode + ((statusType() == null) ? 0 : statusType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewRequest)) {
            return false;
        }
        GetUtterancesViewRequest other = (GetUtterancesViewRequest) obj;
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.botVersions() == null ^ this.botVersions() == null) {
            return false;
        }
        if (other.botVersions() != null && !other.botVersions().equals(this.botVersions())) {
            return false;
        }
        if (other.statusType() == null ^ this.statusType() == null) {
            return false;
        }
        if (other.statusType() != null && !other.statusType().equals(this.statusType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (botVersions() != null) {
            sb.append("BotVersions: ").append(botVersions()).append(",");
        }
        if (statusType() != null) {
            sb.append("StatusType: ").append(statusType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetUtterancesViewRequest> {
        /**
         * <p>
         * The name of the bot for which utterance information should be returned.
         * </p>
         * 
         * @param botName
         *        The name of the bot for which utterance information should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An array of bot versions for which utterance information should be returned. The limit is 5 versions per
         * request.
         * </p>
         * 
         * @param botVersions
         *        An array of bot versions for which utterance information should be returned. The limit is 5 versions
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersions(Collection<String> botVersions);

        /**
         * <p>
         * An array of bot versions for which utterance information should be returned. The limit is 5 versions per
         * request.
         * </p>
         * 
         * @param botVersions
         *        An array of bot versions for which utterance information should be returned. The limit is 5 versions
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersions(String... botVersions);

        /**
         * <p>
         * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that
         * were not recognized, use <code>Missed</code>.
         * </p>
         * 
         * @param statusType
         *        To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
         *        that were not recognized, use <code>Missed</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(String statusType);

        /**
         * <p>
         * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that
         * were not recognized, use <code>Missed</code>.
         * </p>
         * 
         * @param statusType
         *        To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
         *        that were not recognized, use <code>Missed</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(StatusType statusType);
    }

    private static final class BuilderImpl implements Builder {
        private String botName;

        private List<String> botVersions;

        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewRequest model) {
            setBotName(model.botName);
            setBotVersions(model.botVersions);
            setStatusType(model.statusType);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<String> getBotVersions() {
            return botVersions;
        }

        @Override
        public final Builder botVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersions(String... botVersions) {
            botVersions(Arrays.asList(botVersions));
            return this;
        }

        public final void setBotVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
        }

        public final String getStatusType() {
            return statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType.toString());
            return this;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public GetUtterancesViewRequest build() {
            return new GetUtterancesViewRequest(this);
        }
    }
}
