/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetUtterancesViewResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetUtterancesViewResponse.Builder, GetUtterancesViewResponse> {
    private final String botName;

    private final List<UtteranceList> utterances;

    private GetUtterancesViewResponse(BuilderImpl builder) {
        this.botName = builder.botName;
        this.utterances = builder.utterances;
    }

    /**
     * <p>
     * The name of the bot for which utterance information was returned.
     * </p>
     * 
     * @return The name of the bot for which utterance information was returned.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * An array of objects, each containing a list of objects describing the utterances that were processed by your bot.
     * The response contains a maximum of 100 <code>UtteranceData</code> objects for each version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects, each containing a list of objects describing the utterances that were processed by
     *         your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version.
     */
    public List<UtteranceList> utterances() {
        return utterances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((botName() == null) ? 0 : botName().hashCode());
        hashCode = 31 * hashCode + ((utterances() == null) ? 0 : utterances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewResponse)) {
            return false;
        }
        GetUtterancesViewResponse other = (GetUtterancesViewResponse) obj;
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.utterances() == null ^ this.utterances() == null) {
            return false;
        }
        if (other.utterances() != null && !other.utterances().equals(this.utterances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (utterances() != null) {
            sb.append("Utterances: ").append(utterances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetUtterancesViewResponse> {
        /**
         * <p>
         * The name of the bot for which utterance information was returned.
         * </p>
         * 
         * @param botName
         *        The name of the bot for which utterance information was returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An array of objects, each containing a list of objects describing the utterances that were processed by your
         * bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version.
         * </p>
         * 
         * @param utterances
         *        An array of objects, each containing a list of objects describing the utterances that were processed
         *        by your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(Collection<UtteranceList> utterances);

        /**
         * <p>
         * An array of objects, each containing a list of objects describing the utterances that were processed by your
         * bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version.
         * </p>
         * 
         * @param utterances
         *        An array of objects, each containing a list of objects describing the utterances that were processed
         *        by your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(UtteranceList... utterances);
    }

    private static final class BuilderImpl implements Builder {
        private String botName;

        private List<UtteranceList> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewResponse model) {
            setBotName(model.botName);
            setUtterances(model.utterances);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<UtteranceList> getUtterances() {
            return utterances;
        }

        @Override
        public final Builder utterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceList... utterances) {
            utterances(Arrays.asList(utterances));
            return this;
        }

        public final void setUtterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
        }

        @Override
        public GetUtterancesViewResponse build() {
            return new GetUtterancesViewResponse(this);
        }
    }
}
