/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.StatementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of messages that convey information to the user. At runtime, Amazon Lex selects the message to convey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Statement implements StructuredPojo, ToCopyableBuilder<Statement.Builder, Statement> {
    private final List<Message> messages;

    private final String responseCard;

    private Statement(BuilderImpl builder) {
        this.messages = builder.messages;
        this.responseCard = builder.responseCard;
    }

    /**
     * <p>
     * A collection of message objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A collection of message objects.
     */
    public List<Message> messages() {
        return messages;
    }

    /**
     * <p>
     * At runtime, if the client is using the API, Amazon Lex includes the response card in the response. It substitutes
     * all of the session attributes and slot values for placeholders in the response card.
     * </p>
     * 
     * @return At runtime, if the client is using the API, Amazon Lex includes the response card in the response. It
     *         substitutes all of the session attributes and slot values for placeholders in the response card.
     */
    public String responseCard() {
        return responseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((messages() == null) ? 0 : messages().hashCode());
        hashCode = 31 * hashCode + ((responseCard() == null) ? 0 : responseCard().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement) obj;
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        if (other.responseCard() == null ^ this.responseCard() == null) {
            return false;
        }
        if (other.responseCard() != null && !other.responseCard().equals(this.responseCard())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (messages() != null) {
            sb.append("Messages: ").append(messages()).append(",");
        }
        if (responseCard() != null) {
            sb.append("ResponseCard: ").append(responseCard()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Statement> {
        /**
         * <p>
         * A collection of message objects.
         * </p>
         * 
         * @param messages
         *        A collection of message objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A collection of message objects.
         * </p>
         * 
         * @param messages
         *        A collection of message objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * At runtime, if the client is using the API, Amazon Lex includes the response card in the response. It
         * substitutes all of the session attributes and slot values for placeholders in the response card.
         * </p>
         * 
         * @param responseCard
         *        At runtime, if the client is using the API, Amazon Lex includes the response card in the response. It
         *        substitutes all of the session attributes and slot values for placeholders in the response card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCard(String responseCard);
    }

    private static final class BuilderImpl implements Builder {
        private List<Message> messages;

        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            setMessages(model.messages);
            setResponseCard(model.responseCard);
        }

        public final Collection<Message> getMessages() {
            return messages;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
        }

        public final String getResponseCard() {
            return responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        @Override
        public Statement build() {
            return new Statement(this);
        }
    }
}
