/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.services.lexmodelbuilding.model.FollowUpPrompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.FulfillmentActivity;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Slot;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIntentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIntentResponse> {
    private final String name;
    private final String description;
    private final List<Slot> slots;
    private final List<String> sampleUtterances;
    private final Prompt confirmationPrompt;
    private final Statement rejectionStatement;
    private final FollowUpPrompt followUpPrompt;
    private final Statement conclusionStatement;
    private final CodeHook dialogCodeHook;
    private final FulfillmentActivity fulfillmentActivity;
    private final String parentIntentSignature;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final String version;
    private final String checksum;

    private GetIntentResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Slot> slots() {
        return this.slots;
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public Prompt confirmationPrompt() {
        return this.confirmationPrompt;
    }

    public Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public FollowUpPrompt followUpPrompt() {
        return this.followUpPrompt;
    }

    public Statement conclusionStatement() {
        return this.conclusionStatement;
    }

    public CodeHook dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public FulfillmentActivity fulfillmentActivity() {
        return this.fulfillmentActivity;
    }

    public String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public String checksum() {
        return this.checksum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.slots() == null ? 0 : this.slots().hashCode());
        hashCode = 31 * hashCode + (this.sampleUtterances() == null ? 0 : this.sampleUtterances().hashCode());
        hashCode = 31 * hashCode + (this.confirmationPrompt() == null ? 0 : this.confirmationPrompt().hashCode());
        hashCode = 31 * hashCode + (this.rejectionStatement() == null ? 0 : this.rejectionStatement().hashCode());
        hashCode = 31 * hashCode + (this.followUpPrompt() == null ? 0 : this.followUpPrompt().hashCode());
        hashCode = 31 * hashCode + (this.conclusionStatement() == null ? 0 : this.conclusionStatement().hashCode());
        hashCode = 31 * hashCode + (this.dialogCodeHook() == null ? 0 : this.dialogCodeHook().hashCode());
        hashCode = 31 * hashCode + (this.fulfillmentActivity() == null ? 0 : this.fulfillmentActivity().hashCode());
        hashCode = 31 * hashCode + (this.parentIntentSignature() == null ? 0 : this.parentIntentSignature().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedDate() == null ? 0 : this.lastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentResponse)) {
            return false;
        }
        GetIntentResponse other = (GetIntentResponse)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.slots() == null ^ this.slots() == null) {
            return false;
        }
        if (other.slots() != null && !other.slots().equals(this.slots())) {
            return false;
        }
        if (other.sampleUtterances() == null ^ this.sampleUtterances() == null) {
            return false;
        }
        if (other.sampleUtterances() != null && !other.sampleUtterances().equals(this.sampleUtterances())) {
            return false;
        }
        if (other.confirmationPrompt() == null ^ this.confirmationPrompt() == null) {
            return false;
        }
        if (other.confirmationPrompt() != null && !other.confirmationPrompt().equals(this.confirmationPrompt())) {
            return false;
        }
        if (other.rejectionStatement() == null ^ this.rejectionStatement() == null) {
            return false;
        }
        if (other.rejectionStatement() != null && !other.rejectionStatement().equals(this.rejectionStatement())) {
            return false;
        }
        if (other.followUpPrompt() == null ^ this.followUpPrompt() == null) {
            return false;
        }
        if (other.followUpPrompt() != null && !other.followUpPrompt().equals(this.followUpPrompt())) {
            return false;
        }
        if (other.conclusionStatement() == null ^ this.conclusionStatement() == null) {
            return false;
        }
        if (other.conclusionStatement() != null && !other.conclusionStatement().equals(this.conclusionStatement())) {
            return false;
        }
        if (other.dialogCodeHook() == null ^ this.dialogCodeHook() == null) {
            return false;
        }
        if (other.dialogCodeHook() != null && !other.dialogCodeHook().equals(this.dialogCodeHook())) {
            return false;
        }
        if (other.fulfillmentActivity() == null ^ this.fulfillmentActivity() == null) {
            return false;
        }
        if (other.fulfillmentActivity() != null && !other.fulfillmentActivity().equals(this.fulfillmentActivity())) {
            return false;
        }
        if (other.parentIntentSignature() == null ^ this.parentIntentSignature() == null) {
            return false;
        }
        if (other.parentIntentSignature() != null && !other.parentIntentSignature().equals(this.parentIntentSignature())) {
            return false;
        }
        if (other.lastUpdatedDate() == null ^ this.lastUpdatedDate() == null) {
            return false;
        }
        if (other.lastUpdatedDate() != null && !other.lastUpdatedDate().equals(this.lastUpdatedDate())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        return other.checksum() == null || other.checksum().equals(this.checksum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        if (this.sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.sampleUtterances()).append(",");
        }
        if (this.confirmationPrompt() != null) {
            sb.append("ConfirmationPrompt: ").append(this.confirmationPrompt()).append(",");
        }
        if (this.rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(this.rejectionStatement()).append(",");
        }
        if (this.followUpPrompt() != null) {
            sb.append("FollowUpPrompt: ").append(this.followUpPrompt()).append(",");
        }
        if (this.conclusionStatement() != null) {
            sb.append("ConclusionStatement: ").append(this.conclusionStatement()).append(",");
        }
        if (this.dialogCodeHook() != null) {
            sb.append("DialogCodeHook: ").append(this.dialogCodeHook()).append(",");
        }
        if (this.fulfillmentActivity() != null) {
            sb.append("FulfillmentActivity: ").append(this.fulfillmentActivity()).append(",");
        }
        if (this.parentIntentSignature() != null) {
            sb.append("ParentIntentSignature: ").append(this.parentIntentSignature()).append(",");
        }
        if (this.lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(this.lastUpdatedDate()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Slot> slots;
        private List<String> sampleUtterances;
        private Prompt confirmationPrompt;
        private Statement rejectionStatement;
        private FollowUpPrompt followUpPrompt;
        private Statement conclusionStatement;
        private CodeHook dialogCodeHook;
        private FulfillmentActivity fulfillmentActivity;
        private String parentIntentSignature;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private String version;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentResponse model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setSlots(model.slots);
            this.setSampleUtterances(model.sampleUtterances);
            this.setConfirmationPrompt(model.confirmationPrompt);
            this.setRejectionStatement(model.rejectionStatement);
            this.setFollowUpPrompt(model.followUpPrompt);
            this.setConclusionStatement(model.conclusionStatement);
            this.setDialogCodeHook(model.dialogCodeHook);
            this.setFulfillmentActivity(model.fulfillmentActivity);
            this.setParentIntentSignature(model.parentIntentSignature);
            this.setLastUpdatedDate(model.lastUpdatedDate);
            this.setCreatedDate(model.createdDate);
            this.setVersion(model.version);
            this.setChecksum(model.checksum);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot> getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
        }

        public final Collection<String> getSampleUtterances() {
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt getConfirmationPrompt() {
            return this.confirmationPrompt;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
        }

        public final Statement getRejectionStatement() {
            return this.rejectionStatement;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
        }

        public final FollowUpPrompt getFollowUpPrompt() {
            return this.followUpPrompt;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
        }

        public final Statement getConclusionStatement() {
            return this.conclusionStatement;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
        }

        public final CodeHook getDialogCodeHook() {
            return this.dialogCodeHook;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
        }

        public final FulfillmentActivity getFulfillmentActivity() {
            return this.fulfillmentActivity;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public GetIntentResponse build() {
            return new GetIntentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIntentResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slots(Collection<Slot> var1);

        public Builder slots(Slot ... var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder confirmationPrompt(Prompt var1);

        public Builder rejectionStatement(Statement var1);

        public Builder followUpPrompt(FollowUpPrompt var1);

        public Builder conclusionStatement(Statement var1);

        public Builder dialogCodeHook(CodeHook var1);

        public Builder fulfillmentActivity(FulfillmentActivity var1);

        public Builder parentIntentSignature(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder checksum(String var1);
    }
}

