/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListOfUtteranceCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceListMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UtteranceList
implements StructuredPojo,
ToCopyableBuilder<Builder, UtteranceList> {
    private final String botVersion;
    private final List<UtteranceData> utterances;

    private UtteranceList(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.utterances = builder.utterances;
    }

    public String botVersion() {
        return this.botVersion;
    }

    public List<UtteranceData> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.botVersion() == null ? 0 : this.botVersion().hashCode());
        hashCode = 31 * hashCode + (this.utterances() == null ? 0 : this.utterances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceList)) {
            return false;
        }
        UtteranceList other = (UtteranceList)obj;
        if (other.botVersion() == null ^ this.botVersion() == null) {
            return false;
        }
        if (other.botVersion() != null && !other.botVersion().equals(this.botVersion())) {
            return false;
        }
        if (other.utterances() == null ^ this.utterances() == null) {
            return false;
        }
        return other.utterances() == null || other.utterances().equals(this.utterances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.botVersion() != null) {
            sb.append("BotVersion: ").append(this.botVersion()).append(",");
        }
        if (this.utterances() != null) {
            sb.append("Utterances: ").append(this.utterances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String botVersion;
        private List<UtteranceData> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceList model) {
            this.setBotVersion(model.botVersion);
            this.setUtterances(model.utterances);
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Collection<UtteranceData> getUtterances() {
            return this.utterances;
        }

        @Override
        public final Builder utterances(Collection<UtteranceData> utterances) {
            this.utterances = ListOfUtteranceCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceData ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        public final void setUtterances(Collection<UtteranceData> utterances) {
            this.utterances = ListOfUtteranceCopier.copy(utterances);
        }

        public UtteranceList build() {
            return new UtteranceList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UtteranceList> {
        public Builder botVersion(String var1);

        public Builder utterances(Collection<UtteranceData> var1);

        public Builder utterances(UtteranceData ... var1);
    }
}

