/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceList;

@SdkInternalApi
public class UtteranceListMarshaller {
    private static final MarshallingInfo<String> BOTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("botVersion").build();
    private static final MarshallingInfo<List> UTTERANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utterances").build();
    private static final UtteranceListMarshaller INSTANCE = new UtteranceListMarshaller();

    public static UtteranceListMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UtteranceList utteranceList, ProtocolMarshaller protocolMarshaller) {
        if (utteranceList == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)utteranceList.botVersion(), BOTVERSION_BINDING);
            protocolMarshaller.marshall(utteranceList.utterances(), UTTERANCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

