/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotChannelAssociationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBotChannelAssociationsResponse.Builder, GetBotChannelAssociationsResponse> {
    private final List<BotChannelAssociation> botChannelAssociations;

    private final String nextToken;

    private GetBotChannelAssociationsResponse(BuilderImpl builder) {
        this.botChannelAssociations = builder.botChannelAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
     * association with the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects, one for each association, that provides information about the Amazon Lex bot and its
     *         association with the channel.
     */
    public List<BotChannelAssociation> botChannelAssociations() {
        return botChannelAssociations;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of associations. If the response to this call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of associations. If the response to this call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify
     *         the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((botChannelAssociations() == null) ? 0 : botChannelAssociations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationsResponse)) {
            return false;
        }
        GetBotChannelAssociationsResponse other = (GetBotChannelAssociationsResponse) obj;
        if (other.botChannelAssociations() == null ^ this.botChannelAssociations() == null) {
            return false;
        }
        if (other.botChannelAssociations() != null && !other.botChannelAssociations().equals(this.botChannelAssociations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (botChannelAssociations() != null) {
            sb.append("BotChannelAssociations: ").append(botChannelAssociations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botChannelAssociations":
            return Optional.of(clazz.cast(botChannelAssociations()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
        /**
         * <p>
         * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
         * association with the channel.
         * </p>
         * 
         * @param botChannelAssociations
         *        An array of objects, one for each association, that provides information about the Amazon Lex bot and
         *        its association with the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations);

        /**
         * <p>
         * An array of objects, one for each association, that provides information about the Amazon Lex bot and its
         * association with the channel.
         * </p>
         * 
         * @param botChannelAssociations
         *        An array of objects, one for each association, that provides information about the Amazon Lex bot and
         *        its association with the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botChannelAssociations(BotChannelAssociation... botChannelAssociations);

        /**
         * <p>
         * A pagination token that fetches the next page of associations. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of associations. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of
         *        associations, specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<BotChannelAssociation> botChannelAssociations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationsResponse model) {
            botChannelAssociations(model.botChannelAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<BotChannelAssociation.Builder> getBotChannelAssociations() {
            return botChannelAssociations != null ? botChannelAssociations.stream().map(BotChannelAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copy(botChannelAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botChannelAssociations(BotChannelAssociation... botChannelAssociations) {
            botChannelAssociations(Arrays.asList(botChannelAssociations));
            return this;
        }

        public final void setBotChannelAssociations(Collection<BotChannelAssociation.BuilderImpl> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copyFromBuilder(botChannelAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotChannelAssociationsResponse build() {
            return new GetBotChannelAssociationsResponse(this);
        }
    }
}
