/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSlotTypesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetSlotTypesRequest.Builder, GetSlotTypesRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private GetSlotTypesRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of slot types. If the response to this API call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of slot types to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of slot types to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Substring to match in slot type names. A slot type will be returned if any part of its name matches the
     * substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in slot type names. A slot type will be returned if any part of its name matches the
     *         substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nameContains() == null) ? 0 : nameContains().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypesRequest)) {
            return false;
        }
        GetSlotTypesRequest other = (GetSlotTypesRequest) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nameContains() == null ^ this.nameContains() == null) {
            return false;
        }
        if (other.nameContains() != null && !other.nameContains().equals(this.nameContains())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nameContains() != null) {
            sb.append("NameContains: ").append(nameContains()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "nameContains":
            return Optional.of(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetSlotTypesRequest> {
        /**
         * <p>
         * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of slot types. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of slot types to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of slot types to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Substring to match in slot type names. A slot type will be returned if any part of its name matches the
         * substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param nameContains
         *        Substring to match in slot type names. A slot type will be returned if any part of its name matches
         *        the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypesRequest model) {
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public GetSlotTypesRequest build() {
            return new GetSlotTypesRequest(this);
        }
    }
}
