/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource that you are attempting to delete is referred to by another resource. Use this information to remove
 * references to the resource that you are trying to delete.
 * </p>
 * <p>
 * The body of the exception contains a JSON object that describes the resource.
 * </p>
 * <p>
 * <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
 * </p>
 * <p>
 * <code>"resourceReference": {</code>
 * </p>
 * <p>
 * <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceInUseException extends LexModelBuildingException implements
        ToCopyableBuilder<ResourceInUseException.Builder, ResourceInUseException> {
    private final String referenceType;

    private final ResourceReference exampleReference;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder.message);
        this.referenceType = builder.referenceType;
        this.exampleReference = builder.exampleReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ReferenceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeString}.
     * </p>
     * 
     * @return The value of the ReferenceType property for this object.
     * @see ReferenceType
     */
    public ReferenceType referenceType() {
        return ReferenceType.fromValue(referenceType);
    }

    /**
     * Returns the value of the ReferenceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #referenceType}
     * will return {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceTypeString}.
     * </p>
     * 
     * @return The value of the ReferenceType property for this object.
     * @see ReferenceType
     */
    public String referenceTypeString() {
        return referenceType;
    }

    /**
     * Returns the value of the ExampleReference property for this object.
     * 
     * @return The value of the ExampleReference property for this object.
     */
    public ResourceReference exampleReference() {
        return exampleReference;
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceInUseException> {
        /**
         * Sets the value of the ReferenceType property for this object.
         *
         * @param referenceType
         *        The new value for the ReferenceType property for this object.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(String referenceType);

        /**
         * Sets the value of the ReferenceType property for this object.
         *
         * @param referenceType
         *        The new value for the ReferenceType property for this object.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder referenceType(ReferenceType referenceType);

        /**
         * Sets the value of the ExampleReference property for this object.
         *
         * @param exampleReference
         *        The new value for the ExampleReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exampleReference(ResourceReference exampleReference);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String referenceType;

        private ResourceReference exampleReference;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            referenceType(model.referenceType);
            exampleReference(model.exampleReference);
            this.message = model.getMessage();
        }

        public final String getReferenceType() {
            return referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType.toString());
            return this;
        }

        @JsonProperty("referenceType")
        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        public final ResourceReference.Builder getExampleReference() {
            return exampleReference != null ? exampleReference.toBuilder() : null;
        }

        @Override
        public final Builder exampleReference(ResourceReference exampleReference) {
            this.exampleReference = exampleReference;
            return this;
        }

        @JsonProperty("exampleReference")
        public final void setExampleReference(ResourceReference.BuilderImpl exampleReference) {
            this.exampleReference = exampleReference != null ? exampleReference.build() : null;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }
    }
}
