/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a single utterance that was made to your bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UtteranceData implements StructuredPojo, ToCopyableBuilder<UtteranceData.Builder, UtteranceData> {
    private final String utteranceString;

    private final Integer count;

    private final Integer distinctUsers;

    private final Instant firstUtteredDate;

    private final Instant lastUtteredDate;

    private UtteranceData(BuilderImpl builder) {
        this.utteranceString = builder.utteranceString;
        this.count = builder.count;
        this.distinctUsers = builder.distinctUsers;
        this.firstUtteredDate = builder.firstUtteredDate;
        this.lastUtteredDate = builder.lastUtteredDate;
    }

    /**
     * <p>
     * The text that was entered by the user or the text representation of an audio clip.
     * </p>
     * 
     * @return The text that was entered by the user or the text representation of an audio clip.
     */
    public String utteranceString() {
        return utteranceString;
    }

    /**
     * <p>
     * The number of times that the utterance was processed.
     * </p>
     * 
     * @return The number of times that the utterance was processed.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The total number of individuals that used the utterance.
     * </p>
     * 
     * @return The total number of individuals that used the utterance.
     */
    public Integer distinctUsers() {
        return distinctUsers;
    }

    /**
     * <p>
     * The date that the utterance was first recorded.
     * </p>
     * 
     * @return The date that the utterance was first recorded.
     */
    public Instant firstUtteredDate() {
        return firstUtteredDate;
    }

    /**
     * <p>
     * The date that the utterance was last recorded.
     * </p>
     * 
     * @return The date that the utterance was last recorded.
     */
    public Instant lastUtteredDate() {
        return lastUtteredDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((utteranceString() == null) ? 0 : utteranceString().hashCode());
        hashCode = 31 * hashCode + ((count() == null) ? 0 : count().hashCode());
        hashCode = 31 * hashCode + ((distinctUsers() == null) ? 0 : distinctUsers().hashCode());
        hashCode = 31 * hashCode + ((firstUtteredDate() == null) ? 0 : firstUtteredDate().hashCode());
        hashCode = 31 * hashCode + ((lastUtteredDate() == null) ? 0 : lastUtteredDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceData)) {
            return false;
        }
        UtteranceData other = (UtteranceData) obj;
        if (other.utteranceString() == null ^ this.utteranceString() == null) {
            return false;
        }
        if (other.utteranceString() != null && !other.utteranceString().equals(this.utteranceString())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.distinctUsers() == null ^ this.distinctUsers() == null) {
            return false;
        }
        if (other.distinctUsers() != null && !other.distinctUsers().equals(this.distinctUsers())) {
            return false;
        }
        if (other.firstUtteredDate() == null ^ this.firstUtteredDate() == null) {
            return false;
        }
        if (other.firstUtteredDate() != null && !other.firstUtteredDate().equals(this.firstUtteredDate())) {
            return false;
        }
        if (other.lastUtteredDate() == null ^ this.lastUtteredDate() == null) {
            return false;
        }
        if (other.lastUtteredDate() != null && !other.lastUtteredDate().equals(this.lastUtteredDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (utteranceString() != null) {
            sb.append("UtteranceString: ").append(utteranceString()).append(",");
        }
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (distinctUsers() != null) {
            sb.append("DistinctUsers: ").append(distinctUsers()).append(",");
        }
        if (firstUtteredDate() != null) {
            sb.append("FirstUtteredDate: ").append(firstUtteredDate()).append(",");
        }
        if (lastUtteredDate() != null) {
            sb.append("LastUtteredDate: ").append(lastUtteredDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "utteranceString":
            return Optional.of(clazz.cast(utteranceString()));
        case "count":
            return Optional.of(clazz.cast(count()));
        case "distinctUsers":
            return Optional.of(clazz.cast(distinctUsers()));
        case "firstUtteredDate":
            return Optional.of(clazz.cast(firstUtteredDate()));
        case "lastUtteredDate":
            return Optional.of(clazz.cast(lastUtteredDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UtteranceData> {
        /**
         * <p>
         * The text that was entered by the user or the text representation of an audio clip.
         * </p>
         * 
         * @param utteranceString
         *        The text that was entered by the user or the text representation of an audio clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceString(String utteranceString);

        /**
         * <p>
         * The number of times that the utterance was processed.
         * </p>
         * 
         * @param count
         *        The number of times that the utterance was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The total number of individuals that used the utterance.
         * </p>
         * 
         * @param distinctUsers
         *        The total number of individuals that used the utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctUsers(Integer distinctUsers);

        /**
         * <p>
         * The date that the utterance was first recorded.
         * </p>
         * 
         * @param firstUtteredDate
         *        The date that the utterance was first recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstUtteredDate(Instant firstUtteredDate);

        /**
         * <p>
         * The date that the utterance was last recorded.
         * </p>
         * 
         * @param lastUtteredDate
         *        The date that the utterance was last recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUtteredDate(Instant lastUtteredDate);
    }

    static final class BuilderImpl implements Builder {
        private String utteranceString;

        private Integer count;

        private Integer distinctUsers;

        private Instant firstUtteredDate;

        private Instant lastUtteredDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceData model) {
            utteranceString(model.utteranceString);
            count(model.count);
            distinctUsers(model.distinctUsers);
            firstUtteredDate(model.firstUtteredDate);
            lastUtteredDate(model.lastUtteredDate);
        }

        public final String getUtteranceString() {
            return utteranceString;
        }

        @Override
        public final Builder utteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
            return this;
        }

        public final void setUtteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getDistinctUsers() {
            return distinctUsers;
        }

        @Override
        public final Builder distinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
            return this;
        }

        public final void setDistinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
        }

        public final Instant getFirstUtteredDate() {
            return firstUtteredDate;
        }

        @Override
        public final Builder firstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
            return this;
        }

        public final void setFirstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
        }

        public final Instant getLastUtteredDate() {
            return lastUtteredDate;
        }

        @Override
        public final Builder lastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
            return this;
        }

        public final void setLastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
        }

        @Override
        public UtteranceData build() {
            return new UtteranceData(this);
        }
    }
}
