/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceListMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a list of utterances that have been made to a specific version of your bot. The list contains a maximum of
 * 100 utterances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UtteranceList implements StructuredPojo, ToCopyableBuilder<UtteranceList.Builder, UtteranceList> {
    private final String botVersion;

    private final List<UtteranceData> utterances;

    private UtteranceList(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.utterances = builder.utterances;
    }

    /**
     * <p>
     * The version of the bot that processed the list.
     * </p>
     * 
     * @return The version of the bot that processed the list.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * One or more objects that contain information about the utterances that have been made to a bot. The maximum
     * number of object is 100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more objects that contain information about the utterances that have been made to a bot. The
     *         maximum number of object is 100.
     */
    public List<UtteranceData> utterances() {
        return utterances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((botVersion() == null) ? 0 : botVersion().hashCode());
        hashCode = 31 * hashCode + ((utterances() == null) ? 0 : utterances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceList)) {
            return false;
        }
        UtteranceList other = (UtteranceList) obj;
        if (other.botVersion() == null ^ this.botVersion() == null) {
            return false;
        }
        if (other.botVersion() != null && !other.botVersion().equals(this.botVersion())) {
            return false;
        }
        if (other.utterances() == null ^ this.utterances() == null) {
            return false;
        }
        if (other.utterances() != null && !other.utterances().equals(this.utterances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (botVersion() != null) {
            sb.append("BotVersion: ").append(botVersion()).append(",");
        }
        if (utterances() != null) {
            sb.append("Utterances: ").append(utterances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botVersion":
            return Optional.of(clazz.cast(botVersion()));
        case "utterances":
            return Optional.of(clazz.cast(utterances()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UtteranceList> {
        /**
         * <p>
         * The version of the bot that processed the list.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that processed the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * One or more objects that contain information about the utterances that have been made to a bot. The maximum
         * number of object is 100.
         * </p>
         * 
         * @param utterances
         *        One or more objects that contain information about the utterances that have been made to a bot. The
         *        maximum number of object is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(Collection<UtteranceData> utterances);

        /**
         * <p>
         * One or more objects that contain information about the utterances that have been made to a bot. The maximum
         * number of object is 100.
         * </p>
         * 
         * @param utterances
         *        One or more objects that contain information about the utterances that have been made to a bot. The
         *        maximum number of object is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(UtteranceData... utterances);
    }

    static final class BuilderImpl implements Builder {
        private String botVersion;

        private List<UtteranceData> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceList model) {
            botVersion(model.botVersion);
            utterances(model.utterances);
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Collection<UtteranceData.Builder> getUtterances() {
            return utterances != null ? utterances.stream().map(UtteranceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utterances(Collection<UtteranceData> utterances) {
            this.utterances = ListOfUtteranceCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceData... utterances) {
            utterances(Arrays.asList(utterances));
            return this;
        }

        public final void setUtterances(Collection<UtteranceData.BuilderImpl> utterances) {
            this.utterances = ListOfUtteranceCopier.copyFromBuilder(utterances);
        }

        @Override
        public UtteranceList build() {
            return new UtteranceList(this);
        }
    }
}
