/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexmodelbuilding.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateBotVersionResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateBotVersionResponseUnmarshaller implements Unmarshaller<CreateBotVersionResponse, JsonUnmarshallerContext> {

    public CreateBotVersionResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateBotVersionResponse.Builder createBotVersionResponseBuilder = CreateBotVersionResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createBotVersionResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("intents", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.intents(new ListUnmarshaller<Intent>(IntentUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("clarificationPrompt", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.clarificationPrompt(PromptUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("abortStatement", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.abortStatement(StatementUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("failureReason", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.failureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastUpdatedDate", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.lastUpdatedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("createdDate", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.createdDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("idleSessionTTLInSeconds", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.idleSessionTTLInSeconds(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("voiceId", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.voiceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("checksum", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.checksum(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("locale", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.locale(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("childDirected", targetDepth)) {
                    context.nextToken();
                    createBotVersionResponseBuilder.childDirected(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createBotVersionResponseBuilder.build();
    }

    private static final CreateBotVersionResponseUnmarshaller INSTANCE = new CreateBotVersionResponseUnmarshaller();

    public static CreateBotVersionResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
