/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.ChannelConfigurationMapCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.ChannelType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBotChannelAssociationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBotChannelAssociationResponse> {
    private final String name;
    private final String description;
    private final String botAlias;
    private final String botName;
    private final Instant createdDate;
    private final String type;
    private final Map<String, String> botConfiguration;

    private GetBotChannelAssociationResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.botAlias = builder.botAlias;
        this.botName = builder.botName;
        this.createdDate = builder.createdDate;
        this.type = builder.type;
        this.botConfiguration = builder.botConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String botAlias() {
        return this.botAlias;
    }

    public String botName() {
        return this.botName;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Map<String, String> botConfiguration() {
        return this.botConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.botAlias() == null ? 0 : this.botAlias().hashCode());
        hashCode = 31 * hashCode + (this.botName() == null ? 0 : this.botName().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.botConfiguration() == null ? 0 : this.botConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationResponse)) {
            return false;
        }
        GetBotChannelAssociationResponse other = (GetBotChannelAssociationResponse)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.botAlias() == null ^ this.botAlias() == null) {
            return false;
        }
        if (other.botAlias() != null && !other.botAlias().equals(this.botAlias())) {
            return false;
        }
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.botConfiguration() == null ^ this.botConfiguration() == null) {
            return false;
        }
        return other.botConfiguration() == null || other.botConfiguration().equals(this.botConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.botAlias() != null) {
            sb.append("BotAlias: ").append(this.botAlias()).append(",");
        }
        if (this.botName() != null) {
            sb.append("BotName: ").append(this.botName()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.botConfiguration() != null) {
            sb.append("BotConfiguration: ").append(this.botConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "botAlias": {
                return Optional.of(clazz.cast(this.botAlias()));
            }
            case "botName": {
                return Optional.of(clazz.cast(this.botName()));
            }
            case "createdDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "botConfiguration": {
                return Optional.of(clazz.cast(this.botConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String botAlias;
        private String botName;
        private Instant createdDate;
        private String type;
        private Map<String, String> botConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationResponse model) {
            this.name(model.name);
            this.description(model.description);
            this.botAlias(model.botAlias);
            this.botName(model.botName);
            this.createdDate(model.createdDate);
            this.type(model.type);
            this.botConfiguration(model.botConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getBotConfiguration() {
            return this.botConfiguration;
        }

        @Override
        public final Builder botConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
            return this;
        }

        public final void setBotConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
        }

        public GetBotChannelAssociationResponse build() {
            return new GetBotChannelAssociationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBotChannelAssociationResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder botAlias(String var1);

        public Builder botName(String var1);

        public Builder createdDate(Instant var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder botConfiguration(Map<String, String> var1);
    }
}

