/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBotsResponse> {
    private final List<BotMetadata> bots;
    private final String nextToken;

    private GetBotsResponse(BuilderImpl builder) {
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    public List<BotMetadata> bots() {
        return this.bots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bots() == null ? 0 : this.bots().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotsResponse)) {
            return false;
        }
        GetBotsResponse other = (GetBotsResponse)((Object)obj);
        if (other.bots() == null ^ this.bots() == null) {
            return false;
        }
        if (other.bots() != null && !other.bots().equals(this.bots())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bots() != null) {
            sb.append("Bots: ").append(this.bots()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bots": {
                return Optional.of(clazz.cast(this.bots()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<BotMetadata> bots;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotsResponse model) {
            this.bots(model.bots);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotMetadata.Builder> getBots() {
            return this.bots != null ? (Collection)this.bots.stream().map(BotMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata ... bots) {
            this.bots(Arrays.asList(bots));
            return this;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetBotsResponse build() {
            return new GetBotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBotsResponse> {
        public Builder bots(Collection<BotMetadata> var1);

        public Builder bots(BotMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

