/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinIntentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetBuiltinIntentsRequest> {
    private final String locale;
    private final String signatureContains;
    private final String nextToken;
    private final Integer maxResults;

    private GetBuiltinIntentsRequest(BuilderImpl builder) {
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeString() {
        return this.locale;
    }

    public String signatureContains() {
        return this.signatureContains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.localeString() == null ? 0 : this.localeString().hashCode());
        hashCode = 31 * hashCode + (this.signatureContains() == null ? 0 : this.signatureContains().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsRequest)) {
            return false;
        }
        GetBuiltinIntentsRequest other = (GetBuiltinIntentsRequest)((Object)obj);
        if (other.localeString() == null ^ this.localeString() == null) {
            return false;
        }
        if (other.localeString() != null && !other.localeString().equals(this.localeString())) {
            return false;
        }
        if (other.signatureContains() == null ^ this.signatureContains() == null) {
            return false;
        }
        if (other.signatureContains() != null && !other.signatureContains().equals(this.signatureContains())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.localeString() != null) {
            sb.append("Locale: ").append(this.localeString()).append(",");
        }
        if (this.signatureContains() != null) {
            sb.append("SignatureContains: ").append(this.signatureContains()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locale": {
                return Optional.of(clazz.cast(this.localeString()));
            }
            case "signatureContains": {
                return Optional.of(clazz.cast(this.signatureContains()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String locale;
        private String signatureContains;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsRequest model) {
            this.locale(model.locale);
            this.signatureContains(model.signatureContains);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return this.signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public GetBuiltinIntentsRequest build() {
            return new GetBuiltinIntentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinIntentsRequest> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder signatureContains(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

