/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotVersionsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetUtterancesViewRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetUtterancesViewRequest> {
    private final String botName;
    private final List<String> botVersions;
    private final String statusType;

    private GetUtterancesViewRequest(BuilderImpl builder) {
        this.botName = builder.botName;
        this.botVersions = builder.botVersions;
        this.statusType = builder.statusType;
    }

    public String botName() {
        return this.botName;
    }

    public List<String> botVersions() {
        return this.botVersions;
    }

    public StatusType statusType() {
        return StatusType.fromValue(this.statusType);
    }

    public String statusTypeString() {
        return this.statusType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.botName() == null ? 0 : this.botName().hashCode());
        hashCode = 31 * hashCode + (this.botVersions() == null ? 0 : this.botVersions().hashCode());
        hashCode = 31 * hashCode + (this.statusTypeString() == null ? 0 : this.statusTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewRequest)) {
            return false;
        }
        GetUtterancesViewRequest other = (GetUtterancesViewRequest)((Object)obj);
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.botVersions() == null ^ this.botVersions() == null) {
            return false;
        }
        if (other.botVersions() != null && !other.botVersions().equals(this.botVersions())) {
            return false;
        }
        if (other.statusTypeString() == null ^ this.statusTypeString() == null) {
            return false;
        }
        return other.statusTypeString() == null || other.statusTypeString().equals(this.statusTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.botName() != null) {
            sb.append("BotName: ").append(this.botName()).append(",");
        }
        if (this.botVersions() != null) {
            sb.append("BotVersions: ").append(this.botVersions()).append(",");
        }
        if (this.statusTypeString() != null) {
            sb.append("StatusType: ").append(this.statusTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.of(clazz.cast(this.botName()));
            }
            case "botVersions": {
                return Optional.of(clazz.cast(this.botVersions()));
            }
            case "statusType": {
                return Optional.of(clazz.cast(this.statusTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String botName;
        private List<String> botVersions;
        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewRequest model) {
            this.botName(model.botName);
            this.botVersions(model.botVersions);
            this.statusType(model.statusType);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<String> getBotVersions() {
            return this.botVersions;
        }

        @Override
        public final Builder botVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersions(String ... botVersions) {
            this.botVersions(Arrays.asList(botVersions));
            return this;
        }

        public final void setBotVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
        }

        public final String getStatusType() {
            return this.statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType.toString());
            return this;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        public GetUtterancesViewRequest build() {
            return new GetUtterancesViewRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetUtterancesViewRequest> {
        public Builder botName(String var1);

        public Builder botVersions(Collection<String> var1);

        public Builder botVersions(String ... var1);

        public Builder statusType(String var1);

        public Builder statusType(StatusType var1);
    }
}

