/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ReferenceType;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceInUseException
extends LexModelBuildingException
implements ToCopyableBuilder<Builder, ResourceInUseException> {
    private final String referenceType;
    private final ResourceReference exampleReference;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder.message);
        this.referenceType = builder.referenceType;
        this.exampleReference = builder.exampleReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public String referenceTypeString() {
        return this.referenceType;
    }

    public ResourceReference exampleReference() {
        return this.exampleReference;
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceType;
        private ResourceReference exampleReference;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            this.referenceType(model.referenceType);
            this.exampleReference(model.exampleReference);
            this.message = model.getMessage();
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType.toString());
            return this;
        }

        @JsonProperty(value="referenceType")
        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        public final ResourceReference.Builder getExampleReference() {
            return this.exampleReference != null ? this.exampleReference.toBuilder() : null;
        }

        @Override
        public final Builder exampleReference(ResourceReference exampleReference) {
            this.exampleReference = exampleReference;
            return this;
        }

        @JsonProperty(value="exampleReference")
        public final void setExampleReference(ResourceReference.BuilderImpl exampleReference) {
            this.exampleReference = exampleReference != null ? exampleReference.build() : null;
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceInUseException> {
        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);

        public Builder exampleReference(ResourceReference var1);

        public Builder message(String var1);
    }
}

