/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;

@SdkInternalApi
public class StatementMarshaller {
    private static final MarshallingInfo<List> MESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messages").build();
    private static final MarshallingInfo<String> RESPONSECARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseCard").build();
    private static final StatementMarshaller INSTANCE = new StatementMarshaller();

    public static StatementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Statement statement, ProtocolMarshaller protocolMarshaller) {
        if (statement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(statement.messages(), MESSAGES_BINDING);
            protocolMarshaller.marshall((Object)statement.responseCard(), RESPONSECARD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

