/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.lexmodelbuilding.model.BadRequestException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ConflictException;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.InternalFailureException;
import software.amazon.awssdk.services.lexmodelbuilding.model.LimitExceededException;
import software.amazon.awssdk.services.lexmodelbuilding.model.NotFoundException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceInUseException;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateBotVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateIntentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateSlotTypeVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotChannelAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteUtterancesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinSlotTypesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetExportResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetUtterancesViewRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetUtterancesViewResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutSlotTypeResponseUnmarshaller;

/**
 * Internal implementation of {@link LexModelBuildingAsyncClient}.
 *
 * @see LexModelBuildingAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelBuildingAsyncClient implements LexModelBuildingAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultLexModelBuildingAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>&#36LATEST</code> version. If the <code>&#36LATEST</code>
     * version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new
     * version. It returns the last created version.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the bot. You can't update the numbered versions that
     * you create with the <code>CreateBotVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:CreateBotVersion</code> action.
     * </p>
     *
     * @param createBotVersionRequest
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotVersionResponse> createBotVersion(CreateBotVersionRequest createBotVersionRequest) {

        HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateBotVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                .withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createBotVersionRequest));
    }

    /**
     * <p>
     * Creates a new version of an intent based on the <code>&#36LATEST</code> version of the intent. If the
     * <code>&#36LATEST</code> version of this intent hasn't changed since you last updated it, Amazon Lex doesn't
     * create a new version. It returns the last version you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the intent. You can't update the numbered versions
     * that you create with the <code>CreateIntentVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For
     * more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action.
     * </p>
     *
     * @param createIntentVersionRequest
     * @return A Java Future containing the result of the CreateIntentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateIntentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateIntentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIntentVersionResponse> createIntentVersion(
            CreateIntentVersionRequest createIntentVersionRequest) {

        HttpResponseHandler<CreateIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateIntentVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateIntentVersionRequest, CreateIntentVersionResponse>()
                .withMarshaller(new CreateIntentVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createIntentVersionRequest));
    }

    /**
     * <p>
     * Creates a new version of a slot type based on the <code>&#36LATEST</code> version of the specified slot type. If
     * the <code>&#36LATEST</code> version of this resource has not changed since the last version that you created,
     * Amazon Lex doesn't create a new version. It returns the last version that you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of a slot type. You can't update the numbered versions
     * that you create with the <code>CreateSlotTypeVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.
     * </p>
     *
     * @param createSlotTypeVersionRequest
     * @return A Java Future containing the result of the CreateSlotTypeVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.CreateSlotTypeVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSlotTypeVersionResponse> createSlotTypeVersion(
            CreateSlotTypeVersionRequest createSlotTypeVersionRequest) {

        HttpResponseHandler<CreateSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateSlotTypeVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateSlotTypeVersionRequest, CreateSlotTypeVersionResponse>()
                .withMarshaller(new CreateSlotTypeVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSlotTypeVersionRequest));
    }

    /**
     * <p>
     * Deletes all versions of the bot, including the <code>&#36LATEST</code> version. To delete a specific version of
     * the bot, use the <a>DeleteBotVersion</a> operation.
     * </p>
     * <p>
     * If a bot has an alias, you can't delete it. Instead, the <code>DeleteBot</code> operation returns a
     * <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To
     * remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring
     * alias until the <code>DeleteBot</code> operation is successful.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBot</code> action.
     * </p>
     *
     * @param deleteBotRequest
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {

        HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>()
                .withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotRequest));
    }

    /**
     * <p>
     * Deletes an alias for the specified bot.
     * </p>
     * <p>
     * You can't delete an alias that is used in the association between a bot and a messaging channel. If an alias is
     * used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception that includes a reference to the channel association that refers to the bot. You can remove the
     * reference to the alias by deleting the channel association. If you get the same exception again, delete the
     * referring association until the <code>DeleteBotAlias</code> operation is successful.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) {

        HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotAliasResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                .withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotAliasRequest));
    }

    /**
     * <p>
     * Deletes the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.
     * </p>
     *
     * @param deleteBotChannelAssociationRequest
     * @return A Java Future containing the result of the DeleteBotChannelAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotChannelAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotChannelAssociationResponse> deleteBotChannelAssociation(
            DeleteBotChannelAssociationRequest deleteBotChannelAssociationRequest) {

        HttpResponseHandler<DeleteBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotChannelAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteBotChannelAssociationRequest, DeleteBotChannelAssociationResponse>()
                        .withMarshaller(new DeleteBotChannelAssociationRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteBotChannelAssociationRequest));
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) {

        HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                .withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotVersionRequest));
    }

    /**
     * <p>
     * Deletes all versions of the intent, including the <code>&#36LATEST</code> version. To delete a specific version
     * of the intent, use the <a>DeleteIntentVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in
     * one or more bots (see <a>how-it-works</a>), you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where
     * the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get
     * the same exception when you attempt to delete the intent again, repeat until the intent has no references and the
     * call to <code>DeleteIntent</code> is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteIntent</code> action.
     * </p>
     *
     * @param deleteIntentRequest
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntentResponse> deleteIntent(DeleteIntentRequest deleteIntentRequest) {

        HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                .withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntentRequest));
    }

    /**
     * <p>
     * Deletes a specific version of an intent. To delete all versions of a intent, use the <a>DeleteIntent</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.
     * </p>
     *
     * @param deleteIntentVersionRequest
     * @return A Java Future containing the result of the DeleteIntentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteIntentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntentVersionResponse> deleteIntentVersion(
            DeleteIntentVersionRequest deleteIntentVersionRequest) {

        HttpResponseHandler<DeleteIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntentVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteIntentVersionRequest, DeleteIntentVersionResponse>()
                .withMarshaller(new DeleteIntentVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntentVersionRequest));
    }

    /**
     * <p>
     * Deletes all versions of the slot type, including the <code>&#36LATEST</code> version. To delete a specific
     * version of the slot type, use the <a>DeleteSlotTypeVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to
     * in one or more intents, you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that
     * shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the
     * intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until
     * the slot type has no references and the <code>DeleteSlotType</code> call is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteSlotType</code> action.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) {

        HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                .withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSlotTypeRequest));
    }

    /**
     * <p>
     * Deletes a specific version of a slot type. To delete all versions of a slot type, use the <a>DeleteSlotType</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.
     * </p>
     *
     * @param deleteSlotTypeVersionRequest
     * @return A Java Future containing the result of the DeleteSlotTypeVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>ResourceInUseException The resource that you are attempting to delete is referred to by another
     *         resource. Use this information to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code></li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteSlotTypeVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotTypeVersionResponse> deleteSlotTypeVersion(
            DeleteSlotTypeVersionRequest deleteSlotTypeVersionRequest) {

        HttpResponseHandler<DeleteSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSlotTypeVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeVersionRequest, DeleteSlotTypeVersionResponse>()
                .withMarshaller(new DeleteSlotTypeVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSlotTypeVersionRequest));
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot unless the <code>childDirected</code> field in the
     * bot is set to <code>true</code>. Utterances are stored for 15 days for use with the <a>GetUtterancesView</a>
     * operation, and then stored indefinately for use in improving the ability of your bot to respond to user input.
     * </p>
     * <p>
     * Use the <code>DeleteStoredUtterances</code> operation to manually delete stored utterances for a specific user.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteUtterances</code> action.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return A Java Future containing the result of the DeleteUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.DeleteUtterances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUtterancesResponse> deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) {

        HttpResponseHandler<DeleteUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUtterancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteUtterancesRequest, DeleteUtterancesResponse>()
                .withMarshaller(new DeleteUtterancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteUtterancesRequest));
    }

    /**
     * <p>
     * Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBot</code> action.
     * </p>
     *
     * @param getBotRequest
     * @return A Java Future containing the result of the GetBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotResponse> getBot(GetBotRequest getBotRequest) {

        HttpResponseHandler<GetBotResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotRequest, GetBotResponse>()
                .withMarshaller(new GetBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBotRequest));
    }

    /**
     * <p>
     * Returns information about an Amazon Lex bot alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAlias</code> action.
     * </p>
     *
     * @param getBotAliasRequest
     * @return A Java Future containing the result of the GetBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotAliasResponse> getBotAlias(GetBotAliasRequest getBotAliasRequest) {

        HttpResponseHandler<GetBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotAliasResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotAliasRequest, GetBotAliasResponse>()
                .withMarshaller(new GetBotAliasRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBotAliasRequest));
    }

    /**
     * <p>
     * Returns a list of aliases for a specified Amazon Lex bot.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAliases</code> action.
     * </p>
     *
     * @param getBotAliasesRequest
     * @return A Java Future containing the result of the GetBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotAliasesResponse> getBotAliases(GetBotAliasesRequest getBotAliasesRequest) {

        HttpResponseHandler<GetBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotAliasesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotAliasesRequest, GetBotAliasesResponse>()
                .withMarshaller(new GetBotAliasesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBotAliasesRequest));
    }

    /**
     * <p>
     * Returns information about the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.
     * </p>
     *
     * @param getBotChannelAssociationRequest
     * @return A Java Future containing the result of the GetBotChannelAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotChannelAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotChannelAssociationResponse> getBotChannelAssociation(
            GetBotChannelAssociationRequest getBotChannelAssociationRequest) {

        HttpResponseHandler<GetBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotChannelAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetBotChannelAssociationRequest, GetBotChannelAssociationResponse>()
                        .withMarshaller(new GetBotChannelAssociationRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getBotChannelAssociationRequest));
    }

    /**
     * <p>
     * Returns a list of all of the channels associated with the specified bot.
     * </p>
     * <p>
     * The <code>GetBotChannelAssociations</code> operation requires permissions for the
     * <code>lex:GetBotChannelAssociations</code> action.
     * </p>
     *
     * @param getBotChannelAssociationsRequest
     * @return A Java Future containing the result of the GetBotChannelAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotChannelAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotChannelAssociationsResponse> getBotChannelAssociations(
            GetBotChannelAssociationsRequest getBotChannelAssociationsRequest) {

        HttpResponseHandler<GetBotChannelAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotChannelAssociationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetBotChannelAssociationsRequest, GetBotChannelAssociationsResponse>()
                        .withMarshaller(new GetBotChannelAssociationsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getBotChannelAssociationsRequest));
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot.
     * For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four
     * <code>BotMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotVersions</code> action.
     * </p>
     *
     * @param getBotVersionsRequest
     * @return A Java Future containing the result of the GetBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotVersionsResponse> getBotVersions(GetBotVersionsRequest getBotVersionsRequest) {

        HttpResponseHandler<GetBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotVersionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotVersionsRequest, GetBotVersionsResponse>()
                .withMarshaller(new GetBotVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBotVersionsRequest));
    }

    /**
     * <p>
     * Returns bot information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you provide the <code>nameContains</code> field, the response includes information for the
     * <code>&#36LATEST</code> version of all bots whose name contains the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, the operation returns information about the
     * <code>&#36LATEST</code> version of all of your bots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permission for the <code>lex:GetBots</code> action.
     * </p>
     *
     * @param getBotsRequest
     * @return A Java Future containing the result of the GetBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBotsResponse> getBots(GetBotsRequest getBotsRequest) {

        HttpResponseHandler<GetBotsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBotsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotsRequest, GetBotsResponse>()
                .withMarshaller(new GetBotsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBotsRequest));
    }

    /**
     * <p>
     * Returns information about a built-in intent.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.
     * </p>
     *
     * @param getBuiltinIntentRequest
     * @return A Java Future containing the result of the GetBuiltinIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinIntentResponse> getBuiltinIntent(GetBuiltinIntentRequest getBuiltinIntentRequest) {

        HttpResponseHandler<GetBuiltinIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinIntentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinIntentRequest, GetBuiltinIntentResponse>()
                .withMarshaller(new GetBuiltinIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBuiltinIntentRequest));
    }

    /**
     * <p>
     * Gets a list of built-in intents that meet the specified criteria.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.
     * </p>
     *
     * @param getBuiltinIntentsRequest
     * @return A Java Future containing the result of the GetBuiltinIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinIntentsResponse> getBuiltinIntents(GetBuiltinIntentsRequest getBuiltinIntentsRequest) {

        HttpResponseHandler<GetBuiltinIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinIntentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinIntentsRequest, GetBuiltinIntentsResponse>()
                .withMarshaller(new GetBuiltinIntentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBuiltinIntentsRequest));
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.
     * </p>
     *
     * @param getBuiltinSlotTypesRequest
     * @return A Java Future containing the result of the GetBuiltinSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetBuiltinSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBuiltinSlotTypesResponse> getBuiltinSlotTypes(
            GetBuiltinSlotTypesRequest getBuiltinSlotTypesRequest) {

        HttpResponseHandler<GetBuiltinSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinSlotTypesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinSlotTypesRequest, GetBuiltinSlotTypesResponse>()
                .withMarshaller(new GetBuiltinSlotTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBuiltinSlotTypesRequest));
    }

    /**
     * <p>
     * Exports the contents of a Amazon Lex resource in a specified format.
     * </p>
     *
     * @param getExportRequest
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetExport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetExport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {

        HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetExportResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>()
                .withMarshaller(new GetExportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getExportRequest));
    }

    /**
     * <p>
     * Returns information about an intent. In addition to the intent name, you must specify the intent version.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:GetIntent</code> action.
     * </p>
     *
     * @param getIntentRequest
     * @return A Java Future containing the result of the GetIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentResponse> getIntent(GetIntentRequest getIntentRequest) {

        HttpResponseHandler<GetIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentRequest, GetIntentResponse>()
                .withMarshaller(new GetIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getIntentRequest));
    }

    /**
     * <p>
     * Gets information about all of the versions of an intent.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an
     * intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation
     * returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetIntentVersions</code> action.
     * </p>
     *
     * @param getIntentVersionsRequest
     * @return A Java Future containing the result of the GetIntentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentVersionsResponse> getIntentVersions(GetIntentVersionsRequest getIntentVersionsRequest) {

        HttpResponseHandler<GetIntentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentVersionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentVersionsRequest, GetIntentVersionsResponse>()
                .withMarshaller(new GetIntentVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getIntentVersionsRequest));
    }

    /**
     * <p>
     * Returns intent information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all intents
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all intents.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetIntents</code> action.
     * </p>
     *
     * @param getIntentsRequest
     * @return A Java Future containing the result of the GetIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetIntentsResponse> getIntents(GetIntentsRequest getIntentsRequest) {

        HttpResponseHandler<GetIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentsRequest, GetIntentsResponse>()
                .withMarshaller(new GetIntentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getIntentsRequest));
    }

    /**
     * <p>
     * Returns information about a specific version of a slot type. In addition to specifying the slot type name, you
     * must specify the slot type version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotType</code> action.
     * </p>
     *
     * @param getSlotTypeRequest
     * @return A Java Future containing the result of the GetSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypeResponse> getSlotType(GetSlotTypeRequest getSlotTypeRequest) {

        HttpResponseHandler<GetSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypeRequest, GetSlotTypeResponse>()
                .withMarshaller(new GetSlotTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSlotTypeRequest));
    }

    /**
     * <p>
     * Gets information about all versions of a slot type.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of
     * a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code>
     * operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and
     * one for the <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.
     * </p>
     *
     * @param getSlotTypeVersionsRequest
     * @return A Java Future containing the result of the GetSlotTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypeVersionsResponse> getSlotTypeVersions(
            GetSlotTypeVersionsRequest getSlotTypeVersionsRequest) {

        HttpResponseHandler<GetSlotTypeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypeVersionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypeVersionsRequest, GetSlotTypeVersionsResponse>()
                .withMarshaller(new GetSlotTypeVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSlotTypeVersionsRequest));
    }

    /**
     * <p>
     * Returns slot type information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all slot types
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetSlotTypes</code> action.
     * </p>
     *
     * @param getSlotTypesRequest
     * @return A Java Future containing the result of the GetSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found. Check the resource and try
     *         again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSlotTypesResponse> getSlotTypes(GetSlotTypesRequest getSlotTypesRequest) {

        HttpResponseHandler<GetSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypesRequest, GetSlotTypesResponse>()
                .withMarshaller(new GetSlotTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSlotTypesRequest));
    }

    /**
     * <p>
     * Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have
     * made to your bot. You can use this list to tune the utterances that your bot responds to.
     * </p>
     * <p>
     * For example, say that you have created a bot to order flowers. After your users have used your bot for a while,
     * use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have
     * been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this
     * utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.
     * </p>
     * <p>
     * After you publish a new version of a bot, you can get information about the old version and the new so that you
     * can compare the performance across the two versions.
     * </p>
     * <p>
     * Data is available for the last 15 days. You can request information for up to 5 versions in each request. The
     * response contains information about a maximum of 100 utterances for each version.
     * </p>
     * <p>
     * If the bot's <code>childDirected</code> field is set to <code>true</code>, utterances for the bot are not stored
     * and cannot be retrieved with the <code>GetUtterancesView</code> operation. For more information, see
     * <a>PutBot</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetUtterancesView</code> action.
     * </p>
     *
     * @param getUtterancesViewRequest
     * @return A Java Future containing the result of the GetUtterancesView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.GetUtterancesView
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUtterancesViewResponse> getUtterancesView(GetUtterancesViewRequest getUtterancesViewRequest) {

        HttpResponseHandler<GetUtterancesViewResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUtterancesViewResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetUtterancesViewRequest, GetUtterancesViewResponse>()
                .withMarshaller(new GetUtterancesViewRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getUtterancesViewRequest));
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are
     * only required to specify a name. You can use this to add intents later, or to remove intents from an existing
     * bot. When you create a bot with a name only, the bot is created or updated but Amazon Lex returns the
     * <code/> response <code>FAILED</code>. You can build the bot after you add one or more intents. For more
     * information about Amazon Lex bots, see <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing bot, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the bot. Amazon Lex removes any fields that you don't provide values for in
     * the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set
     * to their default values. If you don't specify values for required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see
     * <a>auth-and-access-control</a>.
     * </p>
     *
     * @param putBotRequest
     * @return A Java Future containing the result of the PutBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutBotResponse> putBot(PutBotRequest putBotRequest) {

        HttpResponseHandler<PutBotResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutBotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutBotRequest, PutBotResponse>()
                .withMarshaller(new PutBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putBotRequest));
    }

    /**
     * <p>
     * Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the
     * version of the bot that the alias points to, replace the alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBotAlias</code> action.
     * </p>
     *
     * @param putBotAliasRequest
     * @return A Java Future containing the result of the PutBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutBotAliasResponse> putBotAlias(PutBotAliasRequest putBotAliasRequest) {

        HttpResponseHandler<PutBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutBotAliasResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutBotAliasRequest, PutBotAliasResponse>()
                .withMarshaller(new PutBotAliasRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putBotAliasRequest));
    }

    /**
     * <p>
     * Creates an intent or replaces an existing intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot,
     * for example, you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * To create an intent or replace an existing intent, you must provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Intent name. For example, <code>OrderPizza</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slot types for the information that your bot will request from the user.
     * You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of
     * a pizza.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to the client application. If you use a Lambda function, when all of the intent information is
     * available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information
     * to the client application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify other optional information in the request, such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent has been fulfilled. For example,
     * "I placed your pizza order."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example, asking
     * "Do you want to order a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the
     * <code>&#36LATEST</code> version of the slot type with the values in the request. Amazon Lex removes fields that
     * you don't provide in the request. If you don't specify the required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutIntent</code> action.
     * </p>
     *
     * @param putIntentRequest
     * @return A Java Future containing the result of the PutIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutIntentResponse> putIntent(PutIntentRequest putIntentRequest) {

        HttpResponseHandler<PutIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutIntentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutIntentRequest, PutIntentResponse>()
                .withMarshaller(new PutIntentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putIntentRequest));
    }

    /**
     * <p>
     * Creates a custom slot type or replaces an existing custom slot type.
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the
     * values that a slot of this type can assume. For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing slot type, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the slot type. Amazon Lex removes the fields that you don't provide in the
     * request. If you don't specify required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutSlotType</code> action.
     * </p>
     *
     * @param putSlotTypeRequest
     * @return A Java Future containing the result of the PutSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>LimitExceededException The request exceeded a limit. Try your request again.</li>
     *         <li>InternalFailureException An internal Amazon Lex error occurred. Try your request again.</li>
     *         <li>BadRequestException The request is not well formed. For example, a value is invalid or a required
     *         field is missing. Check the field values, and try again.</li>
     *         <li>PreconditionFailedException The checksum of the resource that you are trying to change does not match
     *         the checksum in the request. Check the resource's checksum and try again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelBuildingException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LexModelBuildingAsyncClient.PutSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutSlotTypeResponse> putSlotType(PutSlotTypeRequest putSlotTypeRequest) {

        HttpResponseHandler<PutSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutSlotTypeRequest, PutSlotTypeResponse>()
                .withMarshaller(new PutSlotTypeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putSlotTypeRequest));
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(
                new JsonClientMetadata()
                        .withProtocolVersion("1.1")
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(
                                software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException.class)
                        .withContentTypeOverride("")
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(
                                        InternalFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                        ResourceInUseException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(
                                        ConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("PreconditionFailedException").withModeledClass(
                                        PreconditionFailedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(
                                        BadRequestException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
