/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteBotChannelAssociationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteBotChannelAssociationRequest.Builder, DeleteBotChannelAssociationRequest> {
    private final String name;

    private final String botName;

    private final String botAlias;

    private DeleteBotChannelAssociationRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
    }

    /**
     * <p>
     * The name of the association. The name is case sensitive.
     * </p>
     * 
     * @return The name of the association. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * An alias that points to the specific version of the Amazon Lex bot to which this association is being made.
     * </p>
     * 
     * @return An alias that points to the specific version of the Amazon Lex bot to which this association is being
     *         made.
     */
    public String botAlias() {
        return botAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotChannelAssociationRequest)) {
            return false;
        }
        DeleteBotChannelAssociationRequest other = (DeleteBotChannelAssociationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(botName(), other.botName())
                && Objects.equals(botAlias(), other.botAlias());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (botAlias() != null) {
            sb.append("BotAlias: ").append(botAlias()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "botName":
            return Optional.of(clazz.cast(botName()));
        case "botAlias":
            return Optional.of(clazz.cast(botAlias()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteBotChannelAssociationRequest> {
        /**
         * <p>
         * The name of the association. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the association. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An alias that points to the specific version of the Amazon Lex bot to which this association is being made.
         * </p>
         * 
         * @param botAlias
         *        An alias that points to the specific version of the Amazon Lex bot to which this association is being
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String botName;

        private String botAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotChannelAssociationRequest model) {
            name(model.name);
            botName(model.botName);
            botAlias(model.botAlias);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        public DeleteBotChannelAssociationRequest build() {
            return new DeleteBotChannelAssociationRequest(this);
        }
    }
}
