/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteUtterancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteUtterancesRequest.Builder, DeleteUtterancesRequest> {
    private final String botName;

    private final String userId;

    private DeleteUtterancesRequest(BuilderImpl builder) {
        this.botName = builder.botName;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The name of the bot that stored the utterances.
     * </p>
     * 
     * @return The name of the bot that stored the utterances.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a
     * href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
     * href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that
     * contained the utterance.
     * </p>
     * 
     * @return The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a
     *         href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
     *         href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request
     *         that contained the utterance.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUtterancesRequest)) {
            return false;
        }
        DeleteUtterancesRequest other = (DeleteUtterancesRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(userId(), other.userId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.of(clazz.cast(botName()));
        case "userId":
            return Optional.of(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteUtterancesRequest> {
        /**
         * <p>
         * The name of the bot that stored the utterances.
         * </p>
         * 
         * @param botName
         *        The name of the bot that stored the utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
         * href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that
         * contained the utterance.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user that made the utterances. This is the user ID that was sent in the
         *        <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a
         *        href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation
         *        request that contained the utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String botName;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUtterancesRequest model) {
            botName(model.botName);
            userId(model.userId);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public DeleteUtterancesRequest build() {
            return new DeleteUtterancesRequest(this);
        }
    }
}
