/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.FollowUpPromptMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A prompt for additional activity after an intent is fulfilled. For example, after the <code>OrderPizza</code> intent
 * is fulfilled, you might prompt the user to find out whether the user wants to order drinks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FollowUpPrompt implements StructuredPojo, ToCopyableBuilder<FollowUpPrompt.Builder, FollowUpPrompt> {
    private final Prompt prompt;

    private final Statement rejectionStatement;

    private FollowUpPrompt(BuilderImpl builder) {
        this.prompt = builder.prompt;
        this.rejectionStatement = builder.rejectionStatement;
    }

    /**
     * <p>
     * Prompts for information from the user.
     * </p>
     * 
     * @return Prompts for information from the user.
     */
    public Prompt prompt() {
        return prompt;
    }

    /**
     * <p>
     * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with this
     * statement to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds
     *         with this statement to acknowledge that the intent was canceled.
     */
    public Statement rejectionStatement() {
        return rejectionStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionStatement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowUpPrompt)) {
            return false;
        }
        FollowUpPrompt other = (FollowUpPrompt) obj;
        return Objects.equals(prompt(), other.prompt()) && Objects.equals(rejectionStatement(), other.rejectionStatement());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (prompt() != null) {
            sb.append("Prompt: ").append(prompt()).append(",");
        }
        if (rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(rejectionStatement()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "prompt":
            return Optional.of(clazz.cast(prompt()));
        case "rejectionStatement":
            return Optional.of(clazz.cast(rejectionStatement()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FollowUpPromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FollowUpPrompt> {
        /**
         * <p>
         * Prompts for information from the user.
         * </p>
         * 
         * @param prompt
         *        Prompts for information from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(Prompt prompt);

        /**
         * <p>
         * Prompts for information from the user.
         * </p>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #prompt(Prompt)}.
         * 
         * @param prompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prompt(Prompt)
         */
        default Builder prompt(Consumer<Prompt.Builder> prompt) {
            return prompt(Prompt.builder().apply(prompt).build());
        }

        /**
         * <p>
         * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param rejectionStatement
         *        If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds
         *        with this statement to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectionStatement(Statement)}.
         * 
         * @param rejectionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectionStatement(Statement)
         */
        default Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return rejectionStatement(Statement.builder().apply(rejectionStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Prompt prompt;

        private Statement rejectionStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowUpPrompt model) {
            prompt(model.prompt);
            rejectionStatement(model.rejectionStatement);
        }

        public final Prompt.Builder getPrompt() {
            return prompt != null ? prompt.toBuilder() : null;
        }

        @Override
        public final Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public final void setPrompt(Prompt.BuilderImpl prompt) {
            this.prompt = prompt != null ? prompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return rejectionStatement != null ? rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        @Override
        public FollowUpPrompt build() {
            return new FollowUpPrompt(this);
        }
    }
}
