/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.FulfillmentActivityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how the intent is fulfilled after the user provides all of the information required for the intent. You can
 * provide a Lambda function to process the intent, or you can return the intent information to the client application.
 * We recommend that you use a Lambda function so that the relevant logic lives in the Cloud and limit the client-side
 * code primarily to presentation. If you need to update the logic, you only update the Lambda function; you don't need
 * to upgrade your client application.
 * </p>
 * <p>
 * Consider the following examples:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In a pizza ordering application, after the user provides all of the information for placing an order, you use a
 * Lambda function to place an order with a pizzeria.
 * </p>
 * </li>
 * <li>
 * <p>
 * In a gaming application, when a user says "pick up a rock," this information must go back to the client application
 * so that it can perform the operation and update the graphics. In this case, you want Amazon Lex to return the intent
 * data to the client.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class FulfillmentActivity implements StructuredPojo, ToCopyableBuilder<FulfillmentActivity.Builder, FulfillmentActivity> {
    private final String type;

    private final CodeHook codeHook;

    private FulfillmentActivity(BuilderImpl builder) {
        this.type = builder.type;
        this.codeHook = builder.codeHook;
    }

    /**
     * <p>
     * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
     * client application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FulfillmentActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to
     *         the client application.
     * @see FulfillmentActivityType
     */
    public FulfillmentActivityType type() {
        return FulfillmentActivityType.fromValue(type);
    }

    /**
     * <p>
     * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
     * client application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FulfillmentActivityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to
     *         the client application.
     * @see FulfillmentActivityType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * A description of the Lambda function that is run to fulfill the intent.
     * </p>
     * 
     * @return A description of the Lambda function that is run to fulfill the intent.
     */
    public CodeHook codeHook() {
        return codeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(codeHook());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentActivity)) {
            return false;
        }
        FulfillmentActivity other = (FulfillmentActivity) obj;
        return Objects.equals(typeString(), other.typeString()) && Objects.equals(codeHook(), other.codeHook());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (codeHook() != null) {
            sb.append("CodeHook: ").append(codeHook()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "codeHook":
            return Optional.of(clazz.cast(codeHook()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FulfillmentActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FulfillmentActivity> {
        /**
         * <p>
         * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
         * client application.
         * </p>
         * 
         * @param type
         *        How the intent should be fulfilled, either by running a Lambda function or by returning the slot data
         *        to the client application.
         * @see FulfillmentActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentActivityType
         */
        Builder type(String type);

        /**
         * <p>
         * How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the
         * client application.
         * </p>
         * 
         * @param type
         *        How the intent should be fulfilled, either by running a Lambda function or by returning the slot data
         *        to the client application.
         * @see FulfillmentActivityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FulfillmentActivityType
         */
        Builder type(FulfillmentActivityType type);

        /**
         * <p>
         * A description of the Lambda function that is run to fulfill the intent.
         * </p>
         * 
         * @param codeHook
         *        A description of the Lambda function that is run to fulfill the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHook(CodeHook codeHook);

        /**
         * <p>
         * A description of the Lambda function that is run to fulfill the intent.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeHook.Builder} avoiding the need to create
         * one manually via {@link CodeHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeHook.Builder#build()} is called immediately and its result is
         * passed to {@link #codeHook(CodeHook)}.
         * 
         * @param codeHook
         *        a consumer that will call methods on {@link CodeHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHook(CodeHook)
         */
        default Builder codeHook(Consumer<CodeHook.Builder> codeHook) {
            return codeHook(CodeHook.builder().apply(codeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private CodeHook codeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentActivity model) {
            type(model.type);
            codeHook(model.codeHook);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FulfillmentActivityType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final CodeHook.Builder getCodeHook() {
            return codeHook != null ? codeHook.toBuilder() : null;
        }

        @Override
        public final Builder codeHook(CodeHook codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        public final void setCodeHook(CodeHook.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        public FulfillmentActivity build() {
            return new FulfillmentActivity(this);
        }
    }
}
