/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotAliasesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBotAliasesResponse.Builder, GetBotAliasesResponse> {
    private final List<BotAliasMetadata> botAliases;

    private final String nextToken;

    private GetBotAliasesResponse(BuilderImpl builder) {
        this.botAliases = builder.botAliases;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
     */
    public List<BotAliasMetadata> botAliases() {
        return botAliases;
    }

    /**
     * <p>
     * A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex
     * returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in
     * the next request.
     * </p>
     * 
     * @return A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon
     *         Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination
     *         token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasesResponse)) {
            return false;
        }
        GetBotAliasesResponse other = (GetBotAliasesResponse) obj;
        return Objects.equals(botAliases(), other.botAliases()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (botAliases() != null) {
            sb.append("BotAliases: ").append(botAliases()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BotAliases":
            return Optional.of(clazz.cast(botAliases()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBotAliasesResponse> {
        /**
         * <p>
         * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * </p>
         * 
         * @param botAliases
         *        An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliases(Collection<BotAliasMetadata> botAliases);

        /**
         * <p>
         * An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * </p>
         * 
         * @param botAliases
         *        An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliases(BotAliasMetadata... botAliases);

        /**
         * <p>
         * A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex
         * returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token
         * in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching next page of aliases. If the response to this call is truncated,
         *        Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the
         *        pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<BotAliasMetadata> botAliases;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasesResponse model) {
            botAliases(model.botAliases);
            nextToken(model.nextToken);
        }

        public final Collection<BotAliasMetadata.Builder> getBotAliases() {
            return botAliases != null ? botAliases.stream().map(BotAliasMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botAliases(Collection<BotAliasMetadata> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copy(botAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliases(BotAliasMetadata... botAliases) {
            botAliases(Arrays.asList(botAliases));
            return this;
        }

        public final void setBotAliases(Collection<BotAliasMetadata.BuilderImpl> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copyFromBuilder(botAliases);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotAliasesResponse build() {
            return new GetBotAliasesResponse(this);
        }
    }
}
