/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinSlotTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBuiltinSlotTypesResponse.Builder, GetBuiltinSlotTypesResponse> {
    private final List<BuiltinSlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetBuiltinSlotTypesResponse(BuilderImpl builder) {
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     */
    public List<BuiltinSlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * If the response is truncated, the response includes a pagination token that you can use in your next request to
     * fetch the next page of slot types.
     * </p>
     * 
     * @return If the response is truncated, the response includes a pagination token that you can use in your next
     *         request to fetch the next page of slot types.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesResponse)) {
            return false;
        }
        GetBuiltinSlotTypesResponse other = (GetBuiltinSlotTypesResponse) obj;
        return Objects.equals(slotTypes(), other.slotTypes()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (slotTypes() != null) {
            sb.append("SlotTypes: ").append(slotTypes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypes":
            return Optional.of(clazz.cast(slotTypes()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBuiltinSlotTypesResponse> {
        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes);

        /**
         * <p>
         * If the response is truncated, the response includes a pagination token that you can use in your next request
         * to fetch the next page of slot types.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the response includes a pagination token that you can use in your next
         *        request to fetch the next page of slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<BuiltinSlotTypeMetadata> slotTypes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesResponse model) {
            slotTypes(model.slotTypes);
            nextToken(model.nextToken);
        }

        public final Collection<BuiltinSlotTypeMetadata.Builder> getSlotTypes() {
            return slotTypes != null ? slotTypes.stream().map(BuiltinSlotTypeMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        public final void setSlotTypes(Collection<BuiltinSlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBuiltinSlotTypesResponse build() {
            return new GetBuiltinSlotTypesResponse(this);
        }
    }
}
