/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetExportResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetExportResponse.Builder, GetExportResponse> {
    private final String name;

    private final String version;

    private final String resourceType;

    private final String exportType;

    private final String exportStatus;

    private final String failureReason;

    private final String url;

    private GetExportResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
        this.exportStatus = builder.exportStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
    }

    /**
     * <p>
     * The name of the bot being exported.
     * </p>
     * 
     * @return The name of the bot being exported.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the bot being exported.
     * </p>
     * 
     * @return The version of the bot being exported.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The type of the exported resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the exported resource.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the exported resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the exported resource.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * The format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeString}.
     * </p>
     * 
     * @return The format of the exported data.
     * @see ExportType
     */
    public String exportTypeString() {
        return exportType;
    }

    /**
     * <p>
     * The status of the export.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The export is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The export is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The export could not be completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusString}.
     * </p>
     * 
     * @return The status of the export. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The export is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The export is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The export could not be completed.
     *         </p>
     *         </li>
     * @see ExportStatus
     */
    public ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the export.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The export is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The export is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The export could not be completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusString}.
     * </p>
     * 
     * @return The status of the export. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The export is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The export is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The export could not be completed.
     *         </p>
     *         </li>
     * @see ExportStatus
     */
    public String exportStatusString() {
        return exportStatus;
    }

    /**
     * <p>
     * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the
     * resource.
     * </p>
     * 
     * @return If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export
     *         the resource.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP archive
     * that contains the exported resource in JSON format. The structure of the archive may change. Your code should not
     * rely on the archive structure.
     * </p>
     * 
     * @return An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP
     *         archive that contains the exported resource in JSON format. The structure of the archive may change. Your
     *         code should not rely on the archive structure.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(exportTypeString(), other.exportTypeString())
                && Objects.equals(exportStatusString(), other.exportStatusString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (exportTypeString() != null) {
            sb.append("ExportType: ").append(exportTypeString()).append(",");
        }
        if (exportStatusString() != null) {
            sb.append("ExportStatus: ").append(exportStatusString()).append(",");
        }
        if (failureReason() != null) {
            sb.append("FailureReason: ").append(failureReason()).append(",");
        }
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "version":
            return Optional.of(clazz.cast(version()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "exportType":
            return Optional.of(clazz.cast(exportTypeString()));
        case "exportStatus":
            return Optional.of(clazz.cast(exportStatusString()));
        case "failureReason":
            return Optional.of(clazz.cast(failureReason()));
        case "url":
            return Optional.of(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetExportResponse> {
        /**
         * <p>
         * The name of the bot being exported.
         * </p>
         * 
         * @param name
         *        The name of the bot being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the bot being exported.
         * </p>
         * 
         * @param version
         *        The version of the bot being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The type of the exported resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the exported resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the exported resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the exported resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * The format of the exported data.
         * </p>
         * 
         * @param exportType
         *        The format of the exported data.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        /**
         * <p>
         * The status of the export.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The export is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The export is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The export could not be completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportStatus
         *        The status of the export. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The export is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The export is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The export could not be completed.
         *        </p>
         *        </li>
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the export.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The export is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The export is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The export could not be completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportStatus
         *        The status of the export. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The export is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The export is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The export could not be completed.
         *        </p>
         *        </li>
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the
         * resource.
         * </p>
         * 
         * @param failureReason
         *        If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export
         *        the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP
         * archive that contains the exported resource in JSON format. The structure of the archive may change. Your
         * code should not rely on the archive structure.
         * </p>
         * 
         * @param url
         *        An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a
         *        ZIP archive that contains the exported resource in JSON format. The structure of the archive may
         *        change. Your code should not rely on the archive structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private String resourceType;

        private String exportType;

        private String exportStatus;

        private String failureReason;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            name(model.name);
            version(model.version);
            resourceType(model.resourceType);
            exportType(model.exportType);
            exportStatus(model.exportStatus);
            failureReason(model.failureReason);
            url(model.url);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExportType() {
            return exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType.toString());
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus.toString());
            return this;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public GetExportResponse build() {
            return new GetExportResponse(this);
        }
    }
}
