/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotChannelAssociation;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotChannelAssociationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBotChannelAssociationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
    private final List<BotChannelAssociation> botChannelAssociations;
    private final String nextToken;

    private GetBotChannelAssociationsResponse(BuilderImpl builder) {
        this.botChannelAssociations = builder.botChannelAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<BotChannelAssociation> botChannelAssociations() {
        return this.botChannelAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botChannelAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationsResponse)) {
            return false;
        }
        GetBotChannelAssociationsResponse other = (GetBotChannelAssociationsResponse)((Object)obj);
        return Objects.equals(this.botChannelAssociations(), other.botChannelAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.botChannelAssociations() != null) {
            sb.append("BotChannelAssociations: ").append(this.botChannelAssociations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botChannelAssociations": {
                return Optional.of(clazz.cast(this.botChannelAssociations()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<BotChannelAssociation> botChannelAssociations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationsResponse model) {
            this.botChannelAssociations(model.botChannelAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotChannelAssociation.Builder> getBotChannelAssociations() {
            return this.botChannelAssociations != null ? (Collection)this.botChannelAssociations.stream().map(BotChannelAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copy(botChannelAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botChannelAssociations(BotChannelAssociation ... botChannelAssociations) {
            this.botChannelAssociations(Arrays.asList(botChannelAssociations));
            return this;
        }

        public final void setBotChannelAssociations(Collection<BotChannelAssociation.BuilderImpl> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copyFromBuilder(botChannelAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetBotChannelAssociationsResponse build() {
            return new GetBotChannelAssociationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
        public Builder botChannelAssociations(Collection<BotChannelAssociation> var1);

        public Builder botChannelAssociations(BotChannelAssociation ... var1);

        public Builder nextToken(String var1);
    }
}

