/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlot;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentSlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinIntentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBuiltinIntentResponse> {
    private final String signature;
    private final List<String> supportedLocales;
    private final List<BuiltinIntentSlot> slots;

    private GetBuiltinIntentResponse(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
        this.slots = builder.slots;
    }

    public String signature() {
        return this.signature;
    }

    public List<Locale> supportedLocales() {
        return TypeConverter.convert(this.supportedLocales, Locale::fromValue);
    }

    public List<String> supportedLocalesStrings() {
        return this.supportedLocales;
    }

    public List<BuiltinIntentSlot> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedLocalesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResponse)) {
            return false;
        }
        GetBuiltinIntentResponse other = (GetBuiltinIntentResponse)((Object)obj);
        return Objects.equals(this.signature(), other.signature()) && Objects.equals(this.supportedLocalesStrings(), other.supportedLocalesStrings()) && Objects.equals(this.slots(), other.slots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (this.supportedLocalesStrings() != null) {
            sb.append("SupportedLocales: ").append(this.supportedLocalesStrings()).append(",");
        }
        if (this.slots() != null) {
            sb.append("Slots: ").append(this.slots()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.of(clazz.cast(this.signature()));
            }
            case "supportedLocales": {
                return Optional.of(clazz.cast(this.supportedLocalesStrings()));
            }
            case "slots": {
                return Optional.of(clazz.cast(this.slots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales;
        private List<BuiltinIntentSlot> slots;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentResponse model) {
            this.signature(model.signature);
            this.supportedLocales(model.supportedLocales);
            this.slots(model.slots);
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public final Collection<BuiltinIntentSlot.Builder> getSlots() {
            return this.slots != null ? (Collection)this.slots.stream().map(BuiltinIntentSlot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<BuiltinIntentSlot> slots) {
            this.slots = BuiltinIntentSlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(BuiltinIntentSlot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        public final void setSlots(Collection<BuiltinIntentSlot.BuilderImpl> slots) {
            this.slots = BuiltinIntentSlotListCopier.copyFromBuilder(slots);
        }

        public GetBuiltinIntentResponse build() {
            return new GetBuiltinIntentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinIntentResponse> {
        public Builder signature(String var1);

        public Builder supportedLocales(Collection<String> var1);

        public Builder supportedLocales(String ... var1);

        public Builder slots(Collection<BuiltinIntentSlot> var1);

        public Builder slots(BuiltinIntentSlot ... var1);
    }
}

