/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BuiltinIntentMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinIntentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBuiltinIntentsResponse> {
    private final List<BuiltinIntentMetadata> intents;
    private final String nextToken;

    private GetBuiltinIntentsResponse(BuilderImpl builder) {
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    public List<BuiltinIntentMetadata> intents() {
        return this.intents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsResponse)) {
            return false;
        }
        GetBuiltinIntentsResponse other = (GetBuiltinIntentsResponse)((Object)obj);
        return Objects.equals(this.intents(), other.intents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.intents() != null) {
            sb.append("Intents: ").append(this.intents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intents": {
                return Optional.of(clazz.cast(this.intents()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<BuiltinIntentMetadata> intents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsResponse model) {
            this.intents(model.intents);
            this.nextToken(model.nextToken);
        }

        public final Collection<BuiltinIntentMetadata.Builder> getIntents() {
            return this.intents != null ? (Collection)this.intents.stream().map(BuiltinIntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<BuiltinIntentMetadata> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(BuiltinIntentMetadata ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<BuiltinIntentMetadata.BuilderImpl> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetBuiltinIntentsResponse build() {
            return new GetBuiltinIntentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinIntentsResponse> {
        public Builder intents(Collection<BuiltinIntentMetadata> var1);

        public Builder intents(BuiltinIntentMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

