/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBuiltinSlotTypesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
    private final String locale;
    private final String signatureContains;
    private final String nextToken;
    private final Integer maxResults;

    private GetBuiltinSlotTypesRequest(BuilderImpl builder) {
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeString() {
        return this.locale;
    }

    public String signatureContains() {
        return this.signatureContains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesRequest)) {
            return false;
        }
        GetBuiltinSlotTypesRequest other = (GetBuiltinSlotTypesRequest)((Object)obj);
        return Objects.equals(this.localeString(), other.localeString()) && Objects.equals(this.signatureContains(), other.signatureContains()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.localeString() != null) {
            sb.append("Locale: ").append(this.localeString()).append(",");
        }
        if (this.signatureContains() != null) {
            sb.append("SignatureContains: ").append(this.signatureContains()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locale": {
                return Optional.of(clazz.cast(this.localeString()));
            }
            case "signatureContains": {
                return Optional.of(clazz.cast(this.signatureContains()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String locale;
        private String signatureContains;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesRequest model) {
            this.locale(model.locale);
            this.signatureContains(model.signatureContains);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return this.signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public GetBuiltinSlotTypesRequest build() {
            return new GetBuiltinSlotTypesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder signatureContains(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

