/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.ExportStatus;
import software.amazon.awssdk.services.lexmodelbuilding.model.ExportType;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetExportResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetExportResponse> {
    private final String name;
    private final String version;
    private final String resourceType;
    private final String exportType;
    private final String exportStatus;
    private final String failureReason;
    private final String url;

    private GetExportResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
        this.exportType = builder.exportType;
        this.exportStatus = builder.exportStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public ExportType exportType() {
        return ExportType.fromValue(this.exportType);
    }

    public String exportTypeString() {
        return this.exportType;
    }

    public ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public String exportStatusString() {
        return this.exportStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.exportTypeString(), other.exportTypeString()) && Objects.equals(this.exportStatusString(), other.exportStatusString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.exportTypeString() != null) {
            sb.append("ExportType: ").append(this.exportTypeString()).append(",");
        }
        if (this.exportStatusString() != null) {
            sb.append("ExportStatus: ").append(this.exportStatusString()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "exportType": {
                return Optional.of(clazz.cast(this.exportTypeString()));
            }
            case "exportStatus": {
                return Optional.of(clazz.cast(this.exportStatusString()));
            }
            case "failureReason": {
                return Optional.of(clazz.cast(this.failureReason()));
            }
            case "url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String resourceType;
        private String exportType;
        private String exportStatus;
        private String failureReason;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            this.name(model.name);
            this.version(model.version);
            this.resourceType(model.resourceType);
            this.exportType(model.exportType);
            this.exportStatus(model.exportStatus);
            this.failureReason(model.failureReason);
            this.url(model.url);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExportType() {
            return this.exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType.toString());
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus.toString());
            return this;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public GetExportResponse build() {
            return new GetExportResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetExportResponse> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder exportType(String var1);

        public Builder exportType(ExportType var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);

        public Builder failureReason(String var1);

        public Builder url(String var1);
    }
}

