/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Intent;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.ProcessBehavior;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBotRequest> {
    private final String name;
    private final String description;
    private final List<Intent> intents;
    private final Prompt clarificationPrompt;
    private final Statement abortStatement;
    private final Integer idleSessionTTLInSeconds;
    private final String voiceId;
    private final String checksum;
    private final String processBehavior;
    private final String locale;
    private final Boolean childDirected;

    private PutBotRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.intents = builder.intents;
        this.clarificationPrompt = builder.clarificationPrompt;
        this.abortStatement = builder.abortStatement;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.voiceId = builder.voiceId;
        this.checksum = builder.checksum;
        this.processBehavior = builder.processBehavior;
        this.locale = builder.locale;
        this.childDirected = builder.childDirected;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Intent> intents() {
        return this.intents;
    }

    public Prompt clarificationPrompt() {
        return this.clarificationPrompt;
    }

    public Statement abortStatement() {
        return this.abortStatement;
    }

    public Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public String voiceId() {
        return this.voiceId;
    }

    public String checksum() {
        return this.checksum;
    }

    public ProcessBehavior processBehavior() {
        return ProcessBehavior.fromValue(this.processBehavior);
    }

    public String processBehaviorString() {
        return this.processBehavior;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeString() {
        return this.locale;
    }

    public Boolean childDirected() {
        return this.childDirected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.intents());
        hashCode = 31 * hashCode + Objects.hashCode(this.clarificationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.processBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.childDirected());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBotRequest)) {
            return false;
        }
        PutBotRequest other = (PutBotRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.intents(), other.intents()) && Objects.equals(this.clarificationPrompt(), other.clarificationPrompt()) && Objects.equals(this.abortStatement(), other.abortStatement()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.voiceId(), other.voiceId()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.processBehaviorString(), other.processBehaviorString()) && Objects.equals(this.localeString(), other.localeString()) && Objects.equals(this.childDirected(), other.childDirected());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.intents() != null) {
            sb.append("Intents: ").append(this.intents()).append(",");
        }
        if (this.clarificationPrompt() != null) {
            sb.append("ClarificationPrompt: ").append(this.clarificationPrompt()).append(",");
        }
        if (this.abortStatement() != null) {
            sb.append("AbortStatement: ").append(this.abortStatement()).append(",");
        }
        if (this.idleSessionTTLInSeconds() != null) {
            sb.append("IdleSessionTTLInSeconds: ").append(this.idleSessionTTLInSeconds()).append(",");
        }
        if (this.voiceId() != null) {
            sb.append("VoiceId: ").append(this.voiceId()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.processBehaviorString() != null) {
            sb.append("ProcessBehavior: ").append(this.processBehaviorString()).append(",");
        }
        if (this.localeString() != null) {
            sb.append("Locale: ").append(this.localeString()).append(",");
        }
        if (this.childDirected() != null) {
            sb.append("ChildDirected: ").append(this.childDirected()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "intents": {
                return Optional.of(clazz.cast(this.intents()));
            }
            case "clarificationPrompt": {
                return Optional.of(clazz.cast(this.clarificationPrompt()));
            }
            case "abortStatement": {
                return Optional.of(clazz.cast(this.abortStatement()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.of(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "voiceId": {
                return Optional.of(clazz.cast(this.voiceId()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "processBehavior": {
                return Optional.of(clazz.cast(this.processBehaviorString()));
            }
            case "locale": {
                return Optional.of(clazz.cast(this.localeString()));
            }
            case "childDirected": {
                return Optional.of(clazz.cast(this.childDirected()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Intent> intents;
        private Prompt clarificationPrompt;
        private Statement abortStatement;
        private Integer idleSessionTTLInSeconds;
        private String voiceId;
        private String checksum;
        private String processBehavior;
        private String locale;
        private Boolean childDirected;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBotRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.intents(model.intents);
            this.clarificationPrompt(model.clarificationPrompt);
            this.abortStatement(model.abortStatement);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.voiceId(model.voiceId);
            this.checksum(model.checksum);
            this.processBehavior(model.processBehavior);
            this.locale(model.locale);
            this.childDirected(model.childDirected);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Intent.Builder> getIntents() {
            return this.intents != null ? (Collection)this.intents.stream().map(Intent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<Intent> intents) {
            this.intents = IntentListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Intent ... intents) {
            this.intents(Arrays.asList(intents));
            return this;
        }

        public final void setIntents(Collection<Intent.BuilderImpl> intents) {
            this.intents = IntentListCopier.copyFromBuilder(intents);
        }

        public final Prompt.Builder getClarificationPrompt() {
            return this.clarificationPrompt != null ? this.clarificationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder clarificationPrompt(Prompt clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt;
            return this;
        }

        public final void setClarificationPrompt(Prompt.BuilderImpl clarificationPrompt) {
            this.clarificationPrompt = clarificationPrompt != null ? clarificationPrompt.build() : null;
        }

        public final Statement.Builder getAbortStatement() {
            return this.abortStatement != null ? this.abortStatement.toBuilder() : null;
        }

        @Override
        public final Builder abortStatement(Statement abortStatement) {
            this.abortStatement = abortStatement;
            return this;
        }

        public final void setAbortStatement(Statement.BuilderImpl abortStatement) {
            this.abortStatement = abortStatement != null ? abortStatement.build() : null;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getProcessBehavior() {
            return this.processBehavior;
        }

        @Override
        public final Builder processBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
            return this;
        }

        @Override
        public final Builder processBehavior(ProcessBehavior processBehavior) {
            this.processBehavior(processBehavior.toString());
            return this;
        }

        public final void setProcessBehavior(String processBehavior) {
            this.processBehavior = processBehavior;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Boolean getChildDirected() {
            return this.childDirected;
        }

        @Override
        public final Builder childDirected(Boolean childDirected) {
            this.childDirected = childDirected;
            return this;
        }

        public final void setChildDirected(Boolean childDirected) {
            this.childDirected = childDirected;
        }

        public PutBotRequest build() {
            return new PutBotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBotRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder intents(Collection<Intent> var1);

        public Builder intents(Intent ... var1);

        public Builder clarificationPrompt(Prompt var1);

        default public Builder clarificationPrompt(Consumer<Prompt.Builder> clarificationPrompt) {
            return this.clarificationPrompt((Prompt)((Prompt.Builder)Prompt.builder().apply(clarificationPrompt)).build());
        }

        public Builder abortStatement(Statement var1);

        default public Builder abortStatement(Consumer<Statement.Builder> abortStatement) {
            return this.abortStatement((Statement)((Statement.Builder)Statement.builder().apply(abortStatement)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder voiceId(String var1);

        public Builder checksum(String var1);

        public Builder processBehavior(String var1);

        public Builder processBehavior(ProcessBehavior var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder childDirected(Boolean var1);
    }
}

