/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValuesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotValueSelectionStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutSlotTypeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutSlotTypeResponse> {
    private final String name;
    private final String description;
    private final List<EnumerationValue> enumerationValues;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final String version;
    private final String checksum;
    private final String valueSelectionStrategy;

    private PutSlotTypeResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<EnumerationValue> enumerationValues() {
        return this.enumerationValues;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public String checksum() {
        return this.checksum;
    }

    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(this.valueSelectionStrategy);
    }

    public String valueSelectionStrategyString() {
        return this.valueSelectionStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSelectionStrategyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeResponse)) {
            return false;
        }
        PutSlotTypeResponse other = (PutSlotTypeResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enumerationValues(), other.enumerationValues()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.valueSelectionStrategyString(), other.valueSelectionStrategyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.enumerationValues() != null) {
            sb.append("EnumerationValues: ").append(this.enumerationValues()).append(",");
        }
        if (this.lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(this.lastUpdatedDate()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.valueSelectionStrategyString() != null) {
            sb.append("ValueSelectionStrategy: ").append(this.valueSelectionStrategyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "enumerationValues": {
                return Optional.of(clazz.cast(this.enumerationValues()));
            }
            case "lastUpdatedDate": {
                return Optional.of(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "valueSelectionStrategy": {
                return Optional.of(clazz.cast(this.valueSelectionStrategyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<EnumerationValue> enumerationValues;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private String version;
        private String checksum;
        private String valueSelectionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeResponse model) {
            this.name(model.name);
            this.description(model.description);
            this.enumerationValues(model.enumerationValues);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.checksum(model.checksum);
            this.valueSelectionStrategy(model.valueSelectionStrategy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return this.enumerationValues != null ? (Collection)this.enumerationValues.stream().map(EnumerationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategy() {
            return this.valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        public PutSlotTypeResponse build() {
            return new PutSlotTypeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutSlotTypeResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enumerationValues(Collection<EnumerationValue> var1);

        public Builder enumerationValues(EnumerationValue ... var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder checksum(String var1);

        public Builder valueSelectionStrategy(String var1);

        public Builder valueSelectionStrategy(SlotValueSelectionStrategy var1);
    }
}

