/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotConstraint;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.SlotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Slot
implements StructuredPojo,
ToCopyableBuilder<Builder, Slot> {
    private final String name;
    private final String description;
    private final String slotConstraint;
    private final String slotType;
    private final String slotTypeVersion;
    private final Prompt valueElicitationPrompt;
    private final Integer priority;
    private final List<String> sampleUtterances;
    private final String responseCard;

    private Slot(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotType = builder.slotType;
        this.slotTypeVersion = builder.slotTypeVersion;
        this.valueElicitationPrompt = builder.valueElicitationPrompt;
        this.priority = builder.priority;
        this.sampleUtterances = builder.sampleUtterances;
        this.responseCard = builder.responseCard;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(this.slotConstraint);
    }

    public String slotConstraintString() {
        return this.slotConstraint;
    }

    public String slotType() {
        return this.slotType;
    }

    public String slotTypeVersion() {
        return this.slotTypeVersion;
    }

    public Prompt valueElicitationPrompt() {
        return this.valueElicitationPrompt;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public String responseCard() {
        return this.responseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotConstraintString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueElicitationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleUtterances());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCard());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.slotConstraintString(), other.slotConstraintString()) && Objects.equals(this.slotType(), other.slotType()) && Objects.equals(this.slotTypeVersion(), other.slotTypeVersion()) && Objects.equals(this.valueElicitationPrompt(), other.valueElicitationPrompt()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.responseCard(), other.responseCard());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.slotConstraintString() != null) {
            sb.append("SlotConstraint: ").append(this.slotConstraintString()).append(",");
        }
        if (this.slotType() != null) {
            sb.append("SlotType: ").append(this.slotType()).append(",");
        }
        if (this.slotTypeVersion() != null) {
            sb.append("SlotTypeVersion: ").append(this.slotTypeVersion()).append(",");
        }
        if (this.valueElicitationPrompt() != null) {
            sb.append("ValueElicitationPrompt: ").append(this.valueElicitationPrompt()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.sampleUtterances() != null) {
            sb.append("SampleUtterances: ").append(this.sampleUtterances()).append(",");
        }
        if (this.responseCard() != null) {
            sb.append("ResponseCard: ").append(this.responseCard()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "slotConstraint": {
                return Optional.of(clazz.cast(this.slotConstraintString()));
            }
            case "slotType": {
                return Optional.of(clazz.cast(this.slotType()));
            }
            case "slotTypeVersion": {
                return Optional.of(clazz.cast(this.slotTypeVersion()));
            }
            case "valueElicitationPrompt": {
                return Optional.of(clazz.cast(this.valueElicitationPrompt()));
            }
            case "priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "sampleUtterances": {
                return Optional.of(clazz.cast(this.sampleUtterances()));
            }
            case "responseCard": {
                return Optional.of(clazz.cast(this.responseCard()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SlotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String slotConstraint;
        private String slotType;
        private String slotTypeVersion;
        private Prompt valueElicitationPrompt;
        private Integer priority;
        private List<String> sampleUtterances;
        private String responseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Slot model) {
            this.name(model.name);
            this.description(model.description);
            this.slotConstraint(model.slotConstraint);
            this.slotType(model.slotType);
            this.slotTypeVersion(model.slotTypeVersion);
            this.valueElicitationPrompt(model.valueElicitationPrompt);
            this.priority(model.priority);
            this.sampleUtterances(model.sampleUtterances);
            this.responseCard(model.responseCard);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint.toString());
            return this;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        public final String getSlotType() {
            return this.slotType;
        }

        @Override
        public final Builder slotType(String slotType) {
            this.slotType = slotType;
            return this;
        }

        public final void setSlotType(String slotType) {
            this.slotType = slotType;
        }

        public final String getSlotTypeVersion() {
            return this.slotTypeVersion;
        }

        @Override
        public final Builder slotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
            return this;
        }

        public final void setSlotTypeVersion(String slotTypeVersion) {
            this.slotTypeVersion = slotTypeVersion;
        }

        public final Prompt.Builder getValueElicitationPrompt() {
            return this.valueElicitationPrompt != null ? this.valueElicitationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder valueElicitationPrompt(Prompt valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt;
            return this;
        }

        public final void setValueElicitationPrompt(Prompt.BuilderImpl valueElicitationPrompt) {
            this.valueElicitationPrompt = valueElicitationPrompt != null ? valueElicitationPrompt.build() : null;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<String> getSampleUtterances() {
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SlotUtteranceListCopier.copy(sampleUtterances);
        }

        public final String getResponseCard() {
            return this.responseCard;
        }

        @Override
        public final Builder responseCard(String responseCard) {
            this.responseCard = responseCard;
            return this;
        }

        public final void setResponseCard(String responseCard) {
            this.responseCard = responseCard;
        }

        public Slot build() {
            return new Slot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Slot> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder slotType(String var1);

        public Builder slotTypeVersion(String var1);

        public Builder valueElicitationPrompt(Prompt var1);

        default public Builder valueElicitationPrompt(Consumer<Prompt.Builder> valueElicitationPrompt) {
            return this.valueElicitationPrompt((Prompt)((Prompt.Builder)Prompt.builder().apply(valueElicitationPrompt)).build());
        }

        public Builder priority(Integer var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder responseCard(String var1);
    }
}

