/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListOfUtteranceCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceListMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UtteranceList
implements StructuredPojo,
ToCopyableBuilder<Builder, UtteranceList> {
    private final String botVersion;
    private final List<UtteranceData> utterances;

    private UtteranceList(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.utterances = builder.utterances;
    }

    public String botVersion() {
        return this.botVersion;
    }

    public List<UtteranceData> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.utterances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceList)) {
            return false;
        }
        UtteranceList other = (UtteranceList)obj;
        return Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.utterances(), other.utterances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.botVersion() != null) {
            sb.append("BotVersion: ").append(this.botVersion()).append(",");
        }
        if (this.utterances() != null) {
            sb.append("Utterances: ").append(this.utterances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botVersion": {
                return Optional.of(clazz.cast(this.botVersion()));
            }
            case "utterances": {
                return Optional.of(clazz.cast(this.utterances()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String botVersion;
        private List<UtteranceData> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceList model) {
            this.botVersion(model.botVersion);
            this.utterances(model.utterances);
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Collection<UtteranceData.Builder> getUtterances() {
            return this.utterances != null ? (Collection)this.utterances.stream().map(UtteranceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utterances(Collection<UtteranceData> utterances) {
            this.utterances = ListOfUtteranceCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceData ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        public final void setUtterances(Collection<UtteranceData.BuilderImpl> utterances) {
            this.utterances = ListOfUtteranceCopier.copyFromBuilder(utterances);
        }

        public UtteranceList build() {
            return new UtteranceList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UtteranceList> {
        public Builder botVersion(String var1);

        public Builder utterances(Collection<UtteranceData> var1);

        public Builder utterances(UtteranceData ... var1);
    }
}

