/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;

public final class GetBuiltinIntentsPaginator
implements SdkIterable<GetBuiltinIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinIntentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetBuiltinIntentsPaginator(LexModelBuildingClient client, GetBuiltinIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBuiltinIntentsResponseFetcher();
    }

    public Iterator<GetBuiltinIntentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetBuiltinIntentsResponseFetcher
    implements NextPageFetcher<GetBuiltinIntentsResponse> {
        private GetBuiltinIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinIntentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBuiltinIntentsResponse nextPage(GetBuiltinIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinIntentsPaginator.this.client.getBuiltinIntents(GetBuiltinIntentsPaginator.this.firstRequest);
            }
            return GetBuiltinIntentsPaginator.this.client.getBuiltinIntents((GetBuiltinIntentsRequest)((Object)GetBuiltinIntentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

