/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateIntentVersionRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<CreateIntentVersionRequest.Builder, CreateIntentVersionRequest> {
    private final String name;

    private final String checksum;

    private CreateIntentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the intent that you want to create a new version of. The name is case sensitive.
     * </p>
     * 
     * @return The name of the intent that you want to create a new version of. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you
     * specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex
     * returns a <code>PreconditionFailedException</code> exception and doesn't publish a new version. If you don't
     * specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
     * </p>
     * 
     * @return Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version.
     *         If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum,
     *         Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish a new
     *         version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntentVersionRequest)) {
            return false;
        }
        CreateIntentVersionRequest other = (CreateIntentVersionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(checksum(), other.checksum());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "checksum":
            return Optional.of(clazz.cast(checksum()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, CreateIntentVersionRequest> {
        /**
         * <p>
         * The name of the intent that you want to create a new version of. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the intent that you want to create a new version of. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If
         * you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon
         * Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish a new version. If you
         * don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
         * </p>
         * 
         * @param checksum
         *        Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new
         *        version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different
         *        checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish
         *        a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntentVersionRequest model) {
            name(model.name);
            checksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateIntentVersionRequest build() {
            return new CreateIntentVersionRequest(this);
        }
    }
}
