/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotAliasResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotAliasResponse.Builder, GetBotAliasResponse> {
    private final String name;

    private final String description;

    private final String botVersion;

    private final String botName;

    private final Instant lastUpdatedDate;

    private final Instant createdDate;

    private final String checksum;

    private GetBotAliasResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botName = builder.botName;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the bot alias.
     * </p>
     * 
     * @return The name of the bot alias.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the bot alias.
     * </p>
     * 
     * @return A description of the bot alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot that the alias points to.
     * </p>
     * 
     * @return The version of the bot that the alias points to.
     */
    public String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The name of the bot that the alias points to.
     * </p>
     * 
     * @return The name of the bot that the alias points to.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the bot alias was updated. When you create a resource, the creation date and the last updated date
     * are the same.
     * </p>
     * 
     * @return The date that the bot alias was updated. When you create a resource, the creation date and the last
     *         updated date are the same.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the bot alias was created.
     * </p>
     * 
     * @return The date that the bot alias was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Checksum of the bot alias.
     * </p>
     * 
     * @return Checksum of the bot alias.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasResponse)) {
            return false;
        }
        GetBotAliasResponse other = (GetBotAliasResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(botName(), other.botName())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(checksum(), other.checksum());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (botVersion() != null) {
            sb.append("BotVersion: ").append(botVersion()).append(",");
        }
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(lastUpdatedDate()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "botVersion":
            return Optional.of(clazz.cast(botVersion()));
        case "botName":
            return Optional.of(clazz.cast(botName()));
        case "lastUpdatedDate":
            return Optional.of(clazz.cast(lastUpdatedDate()));
        case "createdDate":
            return Optional.of(clazz.cast(createdDate()));
        case "checksum":
            return Optional.of(clazz.cast(checksum()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetBotAliasResponse> {
        /**
         * <p>
         * The name of the bot alias.
         * </p>
         * 
         * @param name
         *        The name of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the bot alias.
         * </p>
         * 
         * @param description
         *        A description of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot that the alias points to.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The name of the bot that the alias points to.
         * </p>
         * 
         * @param botName
         *        The name of the bot that the alias points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the bot alias was updated. When you create a resource, the creation date and the last updated
         * date are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the bot alias was updated. When you create a resource, the creation date and the last
         *        updated date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The date that the bot alias was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the bot alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Checksum of the bot alias.
         * </p>
         * 
         * @param checksum
         *        Checksum of the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botVersion;

        private String botName;

        private Instant lastUpdatedDate;

        private Instant createdDate;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasResponse model) {
            name(model.name);
            description(model.description);
            botVersion(model.botVersion);
            botName(model.botName);
            lastUpdatedDate(model.lastUpdatedDate);
            createdDate(model.createdDate);
            checksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public GetBotAliasResponse build() {
            return new GetBotAliasResponse(this);
        }
    }
}
