/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotAliasesRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetBotAliasesRequest.Builder, GetBotAliasesRequest> {
    private final String botName;

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private GetBotAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex
     * returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in
     * the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of aliases. If the response to this call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the
     *         pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of aliases to return in the response. The default is 50. .
     * </p>
     * 
     * @return The maximum number of aliases to return in the response. The default is 50. .
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring.
     * For example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in bot alias names. An alias will be returned if any part of its name matches the
     *         substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasesRequest)) {
            return false;
        }
        GetBotAliasesRequest other = (GetBotAliasesRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nameContains(), other.nameContains());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nameContains() != null) {
            sb.append("NameContains: ").append(nameContains()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.of(clazz.cast(botName()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "nameContains":
            return Optional.of(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetBotAliasesRequest> {
        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param botName
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon
         * Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination
         * token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of aliases. If the response to this call is truncated,
         *        Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the
         *        pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of aliases to return in the response. The default is 50. .
         * </p>
         * 
         * @param maxResults
         *        The maximum number of aliases to return in the response. The default is 50. .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Substring to match in bot alias names. An alias will be returned if any part of its name matches the
         * substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param nameContains
         *        Substring to match in bot alias names. An alias will be returned if any part of its name matches the
         *        substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String botName;

        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasesRequest model) {
            botName(model.botName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetBotAliasesRequest build() {
            return new GetBotAliasesRequest(this);
        }
    }
}
