/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotRequest extends LexModelBuildingRequest implements ToCopyableBuilder<GetBotRequest.Builder, GetBotRequest> {
    private final String name;

    private final String versionOrAlias;

    private GetBotRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionOrAlias = builder.versionOrAlias;
    }

    /**
     * <p>
     * The name of the bot. The name is case sensitive.
     * </p>
     * 
     * @return The name of the bot. The name is case sensitive.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version or alias of the bot.
     * </p>
     * 
     * @return The version or alias of the bot.
     */
    public String versionOrAlias() {
        return versionOrAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionOrAlias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotRequest)) {
            return false;
        }
        GetBotRequest other = (GetBotRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(versionOrAlias(), other.versionOrAlias());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (versionOrAlias() != null) {
            sb.append("VersionOrAlias: ").append(versionOrAlias()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "versionOrAlias":
            return Optional.of(clazz.cast(versionOrAlias()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetBotRequest> {
        /**
         * <p>
         * The name of the bot. The name is case sensitive.
         * </p>
         * 
         * @param name
         *        The name of the bot. The name is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version or alias of the bot.
         * </p>
         * 
         * @param versionOrAlias
         *        The version or alias of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionOrAlias(String versionOrAlias);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String versionOrAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotRequest model) {
            name(model.name);
            versionOrAlias(model.versionOrAlias);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionOrAlias() {
            return versionOrAlias;
        }

        @Override
        public final Builder versionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
            return this;
        }

        public final void setVersionOrAlias(String versionOrAlias) {
            this.versionOrAlias = versionOrAlias;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetBotRequest build() {
            return new GetBotRequest(this);
        }
    }
}
