/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIntentVersionsRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetIntentVersionsRequest.Builder, GetIntentVersionsRequest> {
    private final String name;

    private final String nextToken;

    private final Integer maxResults;

    private GetIntentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the intent for which versions should be returned.
     * </p>
     * 
     * @return The name of the intent for which versions should be returned.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of intent versions. If the response to this call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of intent versions. If the response to this call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of intent versions to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of intent versions to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntentVersionsRequest)) {
            return false;
        }
        GetIntentVersionsRequest other = (GetIntentVersionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetIntentVersionsRequest> {
        /**
         * <p>
         * The name of the intent for which versions should be returned.
         * </p>
         * 
         * @param name
         *        The name of the intent for which versions should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A pagination token for fetching the next page of intent versions. If the response to this call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of intent versions. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of intent versions to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of intent versions to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntentVersionsRequest model) {
            name(model.name);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetIntentVersionsRequest build() {
            return new GetIntentVersionsRequest(this);
        }
    }
}
