/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexmodelbuilding.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetExportResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetExportResponseUnmarshaller implements Unmarshaller<GetExportResponse, JsonUnmarshallerContext> {

    public GetExportResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetExportResponse.Builder getExportResponseBuilder = GetExportResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getExportResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("exportType", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.exportType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("exportStatus", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.exportStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("failureReason", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.failureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    getExportResponseBuilder.url(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getExportResponseBuilder.build();
    }

    private static final GetExportResponseUnmarshaller INSTANCE = new GetExportResponseUnmarshaller();

    public static GetExportResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
