/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBotChannelAssociationRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetBotChannelAssociationRequest> {
    private final String name;
    private final String botName;
    private final String botAlias;

    private GetBotChannelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
    }

    public String name() {
        return this.name;
    }

    public String botName() {
        return this.botName;
    }

    public String botAlias() {
        return this.botAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationRequest)) {
            return false;
        }
        GetBotChannelAssociationRequest other = (GetBotChannelAssociationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.botName() != null) {
            sb.append("BotName: ").append(this.botName()).append(",");
        }
        if (this.botAlias() != null) {
            sb.append("BotAlias: ").append(this.botAlias()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "botName": {
                return Optional.of(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.of(clazz.cast(this.botAlias()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String botName;
        private String botAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationRequest model) {
            this.name(model.name);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetBotChannelAssociationRequest build() {
            return new GetBotChannelAssociationRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, GetBotChannelAssociationRequest> {
        public Builder name(String var1);

        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

